/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.codec;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nonnull;

public final class ZigZagLEB128Codec {
    private ZigZagLEB128Codec() {
    }

    public static int encode(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encode(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int decode(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decode(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static void writeSignedInt(int value, @Nonnull DataOutput out) throws IOException {
        ZigZagLEB128Codec.writeUnsignedInt(ZigZagLEB128Codec.encode(value), out);
    }

    public static void writeUnsignedInt(int value, @Nonnull DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value & 0x7F);
    }

    public static void writeSignedLong(long value, @Nonnull DataOutput out) throws IOException {
        ZigZagLEB128Codec.writeUnsignedLong(ZigZagLEB128Codec.encode(value), out);
    }

    private static void writeUnsignedLong(long value, @Nonnull DataOutput out) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte((int)value & 0x7F);
    }

    public static int readSignedInt(@Nonnull DataInput in) throws IOException {
        int raw = ZigZagLEB128Codec.readUnsignedInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedInt(@Nonnull DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new IllegalArgumentException("Variable length quantity is too long: " + i);
        }
        return value | b << i;
    }

    public static long readSignedLong(@Nonnull DataInput in) throws IOException {
        long raw = ZigZagLEB128Codec.readUnsignedLong(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedLong(@Nonnull DataInput in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw new IllegalArgumentException("Variable length quantity is too long: " + i);
        }
        return value | b << i;
    }

    @Deprecated
    public static void writeFloat(float value, DataOutput out) throws IOException {
        int bits = Float.floatToIntBits(value);
        ZigZagLEB128Codec.writeSignedInt(bits, out);
    }

    @Deprecated
    public static float readFloat(@Nonnull DataInput in) throws IOException {
        int bits = ZigZagLEB128Codec.readSignedInt(in);
        return Float.intBitsToFloat(bits);
    }

    @Deprecated
    public static void writeDouble(double value, DataOutput out) throws IOException {
        long bits = Double.doubleToLongBits(value);
        ZigZagLEB128Codec.writeSignedLong(bits, out);
    }

    @Deprecated
    public static double readDouble(@Nonnull DataInput in) throws IOException {
        long bits = ZigZagLEB128Codec.readSignedLong(in);
        return Double.longBitsToDouble(bits);
    }
}

