/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.codec;

import hivemall.utils.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public final class Base91 {
    public static final float WORST_ENCODING_RATIO = 1.2308f;
    public static final float BEST_ENCODING_RATIO = 1.1429f;
    private static final byte[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;
    private static final int BASE;

    @Nonnull
    public static byte[] encode(@Nonnull byte[] input) {
        return Base91.encode(input, 0, input.length);
    }

    @Nonnull
    public static byte[] encode(@Nonnull byte[] input, int offset, int len) {
        int estimatedSize = (int)Math.ceil((float)len * 1.2308f);
        FastByteArrayOutputStream output = new FastByteArrayOutputStream(estimatedSize);
        try {
            Base91.encode(input, offset, len, output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to convert BINARY to BASE91 string", e);
        }
        return output.toByteArray();
    }

    public static void encode(@Nonnull byte[] input, @Nonnull OutputStream output) throws IOException {
        Base91.encode(input, 0, input.length, output);
    }

    public static void encode(@Nonnull byte[] input, int offset, int len, @Nonnull OutputStream output) throws IOException {
        int ebq = 0;
        int en = 0;
        for (int i = offset; i < len; ++i) {
            ebq |= (input[i] & 0xFF) << en;
            if ((en += 8) <= 13) continue;
            int ev = ebq & 0x1FFF;
            if (ev > 88) {
                ebq >>= 13;
                en -= 13;
            } else {
                ev = ebq & 0x3FFF;
                ebq >>= 14;
                en -= 14;
            }
            output.write(ENCODING_TABLE[ev % BASE]);
            output.write(ENCODING_TABLE[ev / BASE]);
        }
        if (en > 0) {
            output.write(ENCODING_TABLE[ebq % BASE]);
            if (en > 7 || ebq > 90) {
                output.write(ENCODING_TABLE[ebq / BASE]);
            }
        }
    }

    public static int encode(@Nonnull byte[] input, int offset, int len, @Nonnull OutputStream output, @Nonnull Base91Buf buf) throws IOException {
        int ebq = buf.queue;
        int en = buf.bits;
        int n = 0;
        for (int i = offset; i < len; ++i) {
            ebq |= (input[i] & 0xFF) << en;
            if ((en += 8) <= 13) continue;
            int ev = ebq & 0x1FFF;
            if (ev > 88) {
                ebq >>= 13;
                en -= 13;
            } else {
                ev = ebq & 0x3FFF;
                ebq >>= 14;
                en -= 14;
            }
            output.write(ENCODING_TABLE[ev % BASE]);
            output.write(ENCODING_TABLE[ev / BASE]);
            n += 2;
        }
        buf.queue = ebq;
        buf.bits = en;
        return n;
    }

    public static void encodeEnd(@Nonnull OutputStream output, @Nonnull Base91Buf buf) throws IOException {
        int ebq = buf.queue;
        int en = buf.bits;
        if (en > 0) {
            output.write(ENCODING_TABLE[ebq % BASE]);
            if (en > 7 || ebq > 90) {
                output.write(ENCODING_TABLE[ebq / BASE]);
            }
        }
        buf.clear();
    }

    public static void encode(@Nonnull InputStream in, @Nonnull OutputStream out) throws IOException {
        int b;
        int ebq = 0;
        int en = 0;
        while ((b = in.read()) != -1) {
            ebq |= (b & 0xFF) << en;
            if ((en += 8) <= 13) continue;
            int ev = ebq & 0x1FFF;
            if (ev > 88) {
                ebq >>= 13;
                en -= 13;
            } else {
                ev = ebq & 0x3FFF;
                ebq >>= 14;
                en -= 14;
            }
            out.write(ENCODING_TABLE[ev % BASE]);
            out.write(ENCODING_TABLE[ev / BASE]);
        }
        if (en > 0) {
            out.write(ENCODING_TABLE[ebq % BASE]);
            if (en > 7 || ebq > 90) {
                out.write(ENCODING_TABLE[ebq / BASE]);
            }
        }
    }

    @Nonnull
    public static byte[] decode(@Nonnull byte[] input) {
        return Base91.decode(input, 0, input.length);
    }

    @Nonnull
    public static byte[] decode(@Nonnull byte[] input, int offset, int len) {
        int expectedSize = Math.round((float)len / 1.1429f);
        FastByteArrayOutputStream output = new FastByteArrayOutputStream(expectedSize);
        try {
            Base91.decode(input, offset, len, output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decode BASE91 binary", e);
        }
        return output.toByteArray();
    }

    public static void decode(@Nonnull byte[] input, @Nonnull OutputStream output) throws IOException {
        Base91.decode(input, 0, input.length, output);
    }

    public static void decode(@Nonnull byte[] input, int offset, int len, @Nonnull OutputStream output) throws IOException {
        int dbq = 0;
        int dn = 0;
        int dv = -1;
        for (int i = offset; i < len; ++i) {
            if (DECODING_TABLE[input[i]] == -1) continue;
            if (dv == -1) {
                dv = DECODING_TABLE[input[i]];
                continue;
            }
            dbq |= (dv += DECODING_TABLE[input[i]] * BASE) << dn;
            dn += (dv & 0x1FFF) > 88 ? 13 : 14;
            do {
                output.write((byte)dbq);
                dbq >>= 8;
            } while ((dn -= 8) >= 8);
            dv = -1;
        }
        if (dv != -1) {
            output.write((byte)(dbq | dv << dn));
        }
    }

    public static int decode(@Nonnull byte[] input, int offset, int len, @Nonnull OutputStream output, @Nonnull Base91Buf buf) throws IOException {
        int dbq = buf.queue;
        int dn = buf.bits;
        int dv = buf.value;
        int n = 0;
        for (int i = offset; i < len; ++i) {
            if (DECODING_TABLE[input[i]] == -1) continue;
            if (dv == -1) {
                dv = DECODING_TABLE[input[i]];
                continue;
            }
            dbq |= (dv += DECODING_TABLE[input[i]] * BASE) << dn;
            dn += (dv & 0x1FFF) > 88 ? 13 : 14;
            do {
                output.write((byte)dbq);
                ++n;
                dbq >>= 8;
            } while ((dn -= 8) >= 8);
            dv = -1;
        }
        buf.queue = dbq;
        buf.bits = dn;
        buf.value = dv;
        return n;
    }

    public static void decodeEnd(@Nonnull OutputStream output, @Nonnull Base91Buf buf) throws IOException {
        int dbq = buf.queue;
        int dn = buf.bits;
        int dv = buf.value;
        if (dv != -1) {
            output.write((byte)(dbq | dv << dn));
        }
        buf.clear();
    }

    public static byte decodeEnd(@Nonnull Base91Buf buf) throws IOException {
        int dv = buf.value;
        if (dv == -1) {
            throw new IllegalStateException("SHOULD not be called");
        }
        int dbq = buf.queue;
        int dn = buf.bits;
        buf.clear();
        return (byte)(dbq | dv << dn);
    }

    public static void decode(@Nonnull InputStream in, @Nonnull OutputStream out) throws IOException {
        int b;
        int dbq = 0;
        int dn = 0;
        int dv = -1;
        while ((b = in.read()) != -1) {
            if (DECODING_TABLE[b] == -1) continue;
            if (dv == -1) {
                dv = DECODING_TABLE[b];
                continue;
            }
            dbq |= (dv += DECODING_TABLE[b] * BASE) << dn;
            dn += (dv & 0x1FFF) > 88 ? 13 : 14;
            do {
                out.write((byte)dbq);
                dbq >>= 8;
            } while ((dn -= 8) >= 8);
            dv = -1;
        }
        if (dv != -1) {
            out.write((byte)(dbq | dv << dn));
        }
    }

    static {
        int i;
        String ts = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,-./:;<=>?@[]^_`{|}~";
        ENCODING_TABLE = ts.getBytes();
        BASE = ENCODING_TABLE.length;
        DECODING_TABLE = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base91.DECODING_TABLE[i] = -1;
        }
        for (i = 0; i < BASE; ++i) {
            Base91.DECODING_TABLE[Base91.ENCODING_TABLE[i]] = (byte)i;
        }
    }

    public static final class Base91Buf {
        private int queue;
        private int bits;
        private int value;

        public Base91Buf() {
            this.clear();
        }

        public boolean isEmpty() {
            return this.value == -1;
        }

        public void clear() {
            this.queue = 0;
            this.bits = 0;
            this.value = -1;
        }
    }
}

