/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.text;

import hivemall.utils.hadoop.WritableUtils;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="split_words", value="_FUNC_(string query [, string regex]) - Returns an array<text> containing splitted strings")
@UDFType(deterministic=true, stateful=false)
public final class SplitWordsUDF
extends UDF {
    public List<Text> evaluate(String query) {
        return this.evaluate(query, "[\\s ]+");
    }

    public List<Text> evaluate(String query, String regex) {
        if (query == null) {
            return null;
        }
        String[] words = query.split(regex, -1);
        return WritableUtils.val(words);
    }
}

