/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.mapred;

import hivemall.utils.hadoop.HadoopUtils;
import hivemall.utils.hadoop.WritableUtils;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.MapredContextAccessor;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;

@Description(name="jobconf_gets", value="_FUNC_() - Returns the value from JobConf")
@UDFType(deterministic=false, stateful=true)
public class JobConfGetsUDF
extends UDF {
    public Text evaluate() throws HiveException {
        return this.evaluate(null);
    }

    public Text evaluate(@Nullable String regexKey) throws HiveException {
        MapredContext ctx = MapredContextAccessor.get();
        if (ctx == null) {
            throw new HiveException("MapredContext is not set");
        }
        JobConf jobconf = ctx.getJobConf();
        if (jobconf == null) {
            throw new HiveException("JobConf is not set");
        }
        String dumped = HadoopUtils.toString(jobconf, regexKey);
        return WritableUtils.val(dumped);
    }
}

