/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.compress;

import hivemall.utils.codec.DeflateCodec;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="inflate", value="_FUNC_(BINARY compressedData) - Returns a decompressed STRING by using Inflater")
@UDFType(deterministic=true, stateful=false)
public final class InflateUDF
extends GenericUDF {
    private BinaryObjectInspector binaryOI;
    @Nonnull
    private transient DeflateCodec codec;
    @Nonnull
    private transient Text result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("_FUNC_ takes exactly 1 argument");
        }
        this.binaryOI = HiveUtils.asBinaryOI(argOIs[0]);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    public Text evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        byte[] decompressed;
        Object arg0;
        if (this.codec == null) {
            this.codec = new DeflateCodec(false, true);
        }
        if ((arg0 = arguments[0].get()) == null) {
            return null;
        }
        BytesWritable b = this.binaryOI.getPrimitiveWritableObject(arg0);
        byte[] compressed = b.getBytes();
        int len = b.getLength();
        try {
            decompressed = this.codec.decompress(compressed, 0, len);
        }
        catch (IOException e) {
            throw new HiveException("Failed to decompressed. Compressed data format is illegal.", (Throwable)e);
        }
        compressed = null;
        if (this.result == null) {
            this.result = new Text(decompressed);
        } else {
            this.result.set(decompressed, 0, decompressed.length);
        }
        return this.result;
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.codec);
        this.codec = null;
        this.result = null;
    }

    public String getDisplayString(String[] children) {
        return "inflate(" + Arrays.toString(children) + ")";
    }
}

