/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.compress;

import hivemall.utils.codec.DeflateCodec;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="deflate", value="_FUNC_(TEXT data [, const int compressionLevel]) - Returns a compressed BINARY obeject by using Deflater.", extended="The compression level must be in range [-1,9]")
@UDFType(deterministic=true, stateful=false)
public final class DeflateUDF
extends GenericUDF {
    private StringObjectInspector stringOI;
    private int compressionLevel;
    @Nullable
    private transient DeflateCodec codec;
    @Nullable
    private transient BytesWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1 && argOIs.length != 2) {
            throw new UDFArgumentException("_FUNC_ takes 1 or 2 arguments");
        }
        this.stringOI = HiveUtils.asStringOI(argOIs[0]);
        int level = -1;
        if (argOIs.length == 2 && ((level = HiveUtils.getConstInt(argOIs[1])) < 0 || level > 9) && level != -1) {
            throw new UDFArgumentException("Invalid compression level: " + level);
        }
        this.compressionLevel = level;
        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    }

    public BytesWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        byte[] compressed;
        Object arg0;
        if (this.codec == null) {
            this.codec = new DeflateCodec(true, false);
        }
        if ((arg0 = arguments[0].get()) == null) {
            return null;
        }
        Text text = this.stringOI.getPrimitiveWritableObject(arg0);
        byte[] original = text.getBytes();
        int len = text.getLength();
        try {
            compressed = this.codec.compress(original, 0, len, this.compressionLevel);
        }
        catch (IOException e) {
            throw new HiveException("Failed to compress", (Throwable)e);
        }
        original = null;
        if (this.result == null) {
            this.result = new BytesWritable(compressed);
        } else {
            this.result.set(compressed, 0, compressed.length);
        }
        return this.result;
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.codec);
        this.codec = null;
        this.result = null;
    }

    public String getDisplayString(String[] children) {
        return "deflate(" + Arrays.toString(children) + ")";
    }
}

