/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.bits;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.WritableUtils;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="bits_or", value="_FUNC_(array<long> b1, array<long> b2, ..) - Returns a logical OR given bitsets")
public final class BitsORUDF
extends GenericUDF {
    private ListObjectInspector[] _listOIs;
    private PrimitiveObjectInspector _listElemOI;
    private BitSet _bitset;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int argLength = argOIs.length;
        if (argLength < 2) {
            throw new UDFArgumentLengthException("Expecting at least two arrays as arguments: " + argLength);
        }
        ListObjectInspector[] argListOIs = new ListObjectInspector[argLength];
        ListObjectInspector arg0ListOI = HiveUtils.asListOI(argOIs[0]);
        PrimitiveObjectInspector arg0ElemOI = HiveUtils.asLongCompatibleOI(arg0ListOI.getListElementObjectInspector());
        argListOIs[0] = arg0ListOI;
        for (int i = 1; i < argLength; ++i) {
            ListObjectInspector listOI = HiveUtils.asListOI(argOIs[i]);
            ObjectInspector elemOI = listOI.getListElementObjectInspector();
            if (!HiveUtils.isNumberOI(elemOI)) {
                throw new UDFArgumentException("Expecting number OI: " + elemOI.getTypeName());
            }
            argListOIs[i] = listOI;
        }
        this._listOIs = argListOIs;
        this._listElemOI = arg0ElemOI;
        this._bitset = new BitSet();
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int numArgs = arguments.length;
        for (int i = 0; i < numArgs; ++i) {
            Object listObj = arguments[i].get();
            if (listObj == null) continue;
            ListObjectInspector listOI = this._listOIs[i];
            int listlen = listOI.getListLength(listObj);
            long[] longs = new long[listlen];
            for (int j = 0; j < listlen; ++j) {
                long v;
                Object elem = listOI.getListElement(listObj, j);
                if (elem == null) {
                    throw new HiveException("Illegal Null value is found in bit representation");
                }
                longs[j] = v = PrimitiveObjectInspectorUtils.getLong((Object)elem, (PrimitiveObjectInspector)this._listElemOI);
            }
            BitSet bs = BitSet.valueOf(longs);
            this._bitset.or(bs);
        }
        long[] longs = this._bitset.toLongArray();
        this._bitset.clear();
        return WritableUtils.toWritableList(longs);
    }

    public String getDisplayString(String[] children) {
        return "bits_or(" + Arrays.toString(children) + ")";
    }
}

