/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.bits;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.WritableUtils;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="bits_collect", value="_FUNC_(int|long x) - Returns a bitset in array<long>")
public final class BitsCollectUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] typeInfo) throws SemanticException {
        if (typeInfo.length != 1) {
            throw new UDFArgumentTypeException(typeInfo.length - 1, "Exactly one argument is expected");
        }
        if (!HiveUtils.isIntegerTypeInfo(typeInfo[0])) {
            throw new UDFArgumentTypeException(0, "_FUNC_(int|long x) is expected: " + typeInfo[0]);
        }
        return new Evaluator();
    }

    public static class Evaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private ListObjectInspector mergeOI;
        private PrimitiveObjectInspector mergeListElemOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] argOIs) throws HiveException {
            assert (argOIs.length == 1);
            super.init(mode, argOIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = HiveUtils.asLongCompatibleOI(argOIs[0]);
            } else {
                this.mergeOI = HiveUtils.asListOI(argOIs[0]);
                this.mergeListElemOI = HiveUtils.asPrimitiveObjectInspector(this.mergeOI.getListElementObjectInspector());
            }
            StandardListObjectInspector outputOI = mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector) : ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            return outputOI;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            ArrayAggregationBuffer ret = new ArrayAggregationBuffer();
            this.reset(ret);
            return ret;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer aggr) throws HiveException {
            ((ArrayAggregationBuffer)aggr).bitset = new BitSet();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer aggr, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            Object arg = parameters[0];
            if (arg != null) {
                int index = PrimitiveObjectInspectorUtils.getInt((Object)arg, (PrimitiveObjectInspector)this.inputOI);
                if (index < 0) {
                    throw new UDFArgumentException("Specified index SHOULD NOT be negative: " + index);
                }
                ArrayAggregationBuffer agg = (ArrayAggregationBuffer)aggr;
                agg.bitset.set(index);
            }
        }

        public List<LongWritable> terminatePartial(GenericUDAFEvaluator.AggregationBuffer aggr) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)aggr;
            long[] array = agg.bitset.toLongArray();
            if (agg.bitset == null || agg.bitset.isEmpty()) {
                return null;
            }
            return WritableUtils.toWritableList(array);
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer aggr, Object other) throws HiveException {
            if (other == null) {
                return;
            }
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)aggr;
            long[] longs = HiveUtils.asLongArray(other, this.mergeOI, this.mergeListElemOI);
            BitSet otherBitset = BitSet.valueOf(longs);
            agg.bitset.or(otherBitset);
        }

        public List<LongWritable> terminate(GenericUDAFEvaluator.AggregationBuffer aggr) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)aggr;
            long[] longs = agg.bitset.toLongArray();
            return WritableUtils.toWritableList(longs);
        }

        static class ArrayAggregationBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            BitSet bitset;

            ArrayAggregationBuffer() {
            }
        }
    }
}

