/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="subarray", value="_FUNC_(array<int> orignal, int fromIndex, int toIndex) - Returns a slice of the original array between the inclusive fromIndex and the exclusive toIndex")
@UDFType(deterministic=true, stateful=false)
public class SubarrayUDF
extends UDF {
    public List<IntWritable> evaluate(List<IntWritable> array, int fromIndex, int toIndex) {
        if (array == null) {
            return null;
        }
        int arraylength = array.size();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex > arraylength) {
            toIndex = arraylength;
        }
        return array.subList(fromIndex, toIndex);
    }
}

