/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="subarray_startwith", value="_FUNC_(array<int|text> original, int|text key) - Returns an array that starts with the specified key")
@UDFType(deterministic=true, stateful=false)
public class SubarrayStartWithUDF
extends UDF {
    public List<IntWritable> evaluate(List<IntWritable> original, IntWritable key) {
        if (original == null) {
            return null;
        }
        int fromIndex = original.indexOf(key);
        if (fromIndex == -1) {
            return null;
        }
        int toIndex = original.size();
        return original.subList(fromIndex, toIndex);
    }

    public List<Text> evaluate(List<Text> original, Text key) {
        if (original == null) {
            return null;
        }
        int fromIndex = original.indexOf(key);
        if (fromIndex == -1) {
            return null;
        }
        int toIndex = original.size();
        return original.subList(fromIndex, toIndex);
    }
}

