/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="collect_all", value="_FUNC_(x) - Retrurns a set of objects with duplicate elements eliminated")
@Deprecated
public class CollectAllUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] tis) throws SemanticException {
        if (tis.length != 1) {
            throw new UDFArgumentTypeException(tis.length - 1, "Exactly one argument is expected.");
        }
        return new CollectAllEvaluator();
    }

    public static class CollectAllEvaluator
    extends GenericUDAFEvaluator {
        private ObjectInspector inputOI;
        private StandardListObjectInspector loi;
        private StandardListObjectInspector internalMergeOI;

        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputOI = parameters[0];
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.inputOI));
            }
            if (!(parameters[0] instanceof StandardListObjectInspector)) {
                this.inputOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)parameters[0]);
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.inputOI);
            }
            this.internalMergeOI = (StandardListObjectInspector)parameters[0];
            this.inputOI = this.internalMergeOI.getListElementObjectInspector();
            this.loi = (StandardListObjectInspector)ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)this.internalMergeOI);
            return this.loi;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ((ArrayAggregationBuffer)ab).container = new ArrayList();
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            ArrayAggregationBuffer ret = new ArrayAggregationBuffer();
            this.reset(ret);
            return ret;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer ab, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            Object p = parameters[0];
            if (p != null) {
                ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
                agg.container.add(ObjectInspectorUtils.copyToStandardObject((Object)p, (ObjectInspector)this.inputOI));
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
            ArrayList<Object> ret = new ArrayList<Object>(agg.container.size());
            ret.addAll(agg.container);
            return ret;
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer ab, Object o) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
            ArrayList partial = (ArrayList)this.internalMergeOI.getList(o);
            for (Object i : partial) {
                agg.container.add(ObjectInspectorUtils.copyToStandardObject(i, (ObjectInspector)this.inputOI));
            }
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer ab) throws HiveException {
            ArrayAggregationBuffer agg = (ArrayAggregationBuffer)ab;
            ArrayList<Object> ret = new ArrayList<Object>(agg.container.size());
            ret.addAll(agg.container);
            return ret;
        }

        static class ArrayAggregationBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            ArrayList<Object> container;

            ArrayAggregationBuffer() {
            }
        }
    }
}

