/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.lang.ArrayUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="array_sum", value="_FUNC_(array<number>) - Returns an array<double> in which each element is summed up")
public final class ArraySumUDAF
extends UDAF {

    public static class PartialResult {
        int _size;
        List<Double> _sum;

        public PartialResult() {
        }

        PartialResult(int size) throws HiveException {
            assert (size > 0) : size;
            this._size = size;
            this._sum = ArrayUtils.toList(new double[size]);
        }

        void update(@Nonnull List<Double> tuple) throws HiveException {
            if (tuple.size() != this._size) {
                throw new HiveException("Mismatch in the number of elements at tuple: " + tuple.toString());
            }
            List<Double> sum = this._sum;
            int len = this._size;
            for (int i = 0; i < len; ++i) {
                Double v = tuple.get(i);
                if (v == null) continue;
                double d = sum.get(i) + v;
                sum.set(i, d);
            }
        }

        void merge(PartialResult other) throws HiveException {
            if (other._size != this._size) {
                throw new HiveException("Mismatch in the number of elements");
            }
            List<Double> sum = this._sum;
            List<Double> o_sum = other._sum;
            int len = this._size;
            for (int i = 0; i < len; ++i) {
                double d = sum.get(i) + o_sum.get(i);
                sum.set(i, d);
            }
        }
    }

    public static class Evaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(List<Double> tuple) throws HiveException {
            if (tuple == null) {
                return true;
            }
            if (tuple.isEmpty()) {
                return true;
            }
            int size = tuple.size();
            if (this.partial == null) {
                this.partial = new PartialResult(size);
            }
            this.partial.update(tuple);
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult other) throws HiveException {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult(other._size);
            }
            this.partial.merge(other);
            return true;
        }

        public List<DoubleWritable> terminate() {
            if (this.partial == null) {
                return null;
            }
            int size = this.partial._size;
            List<Double> sum = this.partial._sum;
            DoubleWritable[] ary = new DoubleWritable[size];
            for (int i = 0; i < size; ++i) {
                Double d = sum.get(i);
                ary[i] = new DoubleWritable(d.doubleValue());
            }
            return Arrays.asList(ary);
        }
    }
}

