/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="array_remove", value="_FUNC_(array<int|text> original, int|text|array<int> target) - Returns an array that the target is removed from the original array")
@UDFType(deterministic=true, stateful=false)
public class ArrayRemoveUDF
extends UDF {
    public List<IntWritable> evaluate(List<IntWritable> original, IntWritable target) {
        while (original.remove(target)) {
        }
        return original;
    }

    public List<IntWritable> evaluate(List<IntWritable> original, List<IntWritable> targets) {
        original.removeAll(targets);
        return original;
    }

    public List<Text> evaluate(List<Text> original, Text target) {
        while (original.remove(target)) {
        }
        return original;
    }
}

