/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_intersect", value="_FUNC_(array<ANY> x1, array<ANY> x2, ..) - Returns an intersect of given arrays")
@UDFType(deterministic=true, stateful=false)
public final class ArrayIntersectUDF
extends GenericUDF {
    private ListObjectInspector[] argListOIs;
    private List<Object> result;

    public ObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        int argLength = argOIs.length;
        if (argLength < 2) {
            throw new UDFArgumentLengthException("Expecting at least two arrays as arguments: " + argLength);
        }
        ListObjectInspector[] argListOIs = new ListObjectInspector[argLength];
        ListObjectInspector arg0ListOI = HiveUtils.asListOI(argOIs[0]);
        ObjectInspector arg0ElemOI = arg0ListOI.getListElementObjectInspector();
        argListOIs[0] = arg0ListOI;
        for (int i = 1; i < argLength; ++i) {
            ListObjectInspector listOI = HiveUtils.asListOI(argOIs[i]);
            if (!ObjectInspectorUtils.compareTypes((ObjectInspector)listOI.getListElementObjectInspector(), (ObjectInspector)arg0ElemOI)) {
                throw new UDFArgumentException("Array types does not match: " + arg0ElemOI.getTypeName() + " != " + listOI.getListElementObjectInspector().getTypeName());
            }
            argListOIs[i] = listOI;
        }
        this.argListOIs = argListOIs;
        this.result = new ArrayList<Object>();
        return ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)arg0ListOI);
    }

    public List<Object> evaluate(@Nonnull GenericUDF.DeferredObject[] args) throws HiveException {
        this.result.clear();
        Object arg0 = args[0].get();
        if (arg0 == null) {
            return Collections.emptyList();
        }
        HashSet<InspectableObject> checkSet = new HashSet<InspectableObject>();
        ListObjectInspector arg0ListOI = this.argListOIs[0];
        ObjectInspector arg0ElemOI = arg0ListOI.getListElementObjectInspector();
        int arg0size = arg0ListOI.getListLength(arg0);
        for (int i = 0; i < arg0size; ++i) {
            Object o = arg0ListOI.getListElement(arg0, i);
            if (o == null) continue;
            checkSet.add(new InspectableObject(o, arg0ElemOI));
        }
        InspectableObject probe = new InspectableObject();
        int numArgs = args.length;
        for (int i = 1; i < numArgs; ++i) {
            Object argI = args[i].get();
            if (argI == null) continue;
            HashSet<InspectableObject> newSet = new HashSet<InspectableObject>();
            ListObjectInspector argIListOI = this.argListOIs[i];
            ObjectInspector argIElemOI = argIListOI.getListElementObjectInspector();
            int j_size = argIListOI.getListLength(argI);
            for (int j = 0; j < j_size; ++j) {
                Object o = argIListOI.getListElement(argI, j);
                if (o == null) continue;
                probe.set(o, argIElemOI);
                if (!checkSet.contains(probe)) continue;
                newSet.add(probe.copy());
            }
            checkSet = newSet;
        }
        for (InspectableObject inspect : checkSet) {
            Object obj = ObjectInspectorUtils.copyToStandardObject((Object)inspect.o, (ObjectInspector)inspect.oi);
            this.result.add(obj);
        }
        return this.result;
    }

    public String getDisplayString(String[] args) {
        return "array_intersect(" + Arrays.toString(args) + ")";
    }

    private static final class InspectableObject
    implements Comparable<InspectableObject> {
        public Object o;
        public ObjectInspector oi;

        InspectableObject() {
        }

        InspectableObject(@Nonnull Object o, @Nonnull ObjectInspector oi) {
            this.o = o;
            this.oi = oi;
        }

        void set(@Nonnull Object o, @Nonnull ObjectInspector oi) {
            this.o = o;
            this.oi = oi;
        }

        InspectableObject copy() {
            return new InspectableObject(this.o, this.oi);
        }

        public int hashCode() {
            return ObjectInspectorUtils.hashCode((Object)this.o, (ObjectInspector)this.oi);
        }

        @Override
        public int compareTo(InspectableObject otherOI) {
            return ObjectInspectorUtils.compare((Object)this.o, (ObjectInspector)this.oi, (Object)otherOI.o, (ObjectInspector)otherOI.oi);
        }

        public boolean equals(Object other) {
            if (!(other instanceof InspectableObject)) {
                return false;
            }
            return this.compareTo((InspectableObject)other) == 0;
        }
    }
}

