/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.array;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_concat", value="_FUNC_(array<ANY> x1, array<ANY> x2, ..) - Returns a concatenated array")
@UDFType(deterministic=true, stateful=false)
public class ArrayConcatUDF
extends GenericUDF {
    private static final String LIST_TYPE_NAME = "array";
    private final List<Object> ret = new ArrayList<Object>();
    private ListObjectInspector[] argumentOIs;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("_FUNC_(array1, array2) needs at least 1 argument.");
        }
        int nargs = arguments.length;
        block3: for (int i = 0; i < nargs; ++i) {
            switch (arguments[i].getCategory()) {
                case LIST: {
                    if (((ListObjectInspector)arguments[i]).getListElementObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) continue block3;
                }
                default: {
                    throw new UDFArgumentTypeException(0, "Argument " + i + " of function CONCAT_ARRAY must be " + LIST_TYPE_NAME + "<" + ObjectInspector.Category.PRIMITIVE + ">, but " + arguments[0].getTypeName() + " was found.");
                }
            }
        }
        ListObjectInspector[] listOIs = new ListObjectInspector[nargs];
        for (int i = 0; i < nargs; ++i) {
            listOIs[i] = (ListObjectInspector)arguments[i];
        }
        this.argumentOIs = listOIs;
        ObjectInspector firstElemOI = listOIs[0].getListElementObjectInspector();
        ObjectInspector returnElemOI = ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)firstElemOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)returnElemOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.ret.clear();
        for (int i = 0; i < arguments.length; ++i) {
            Object arrayObject = arguments[i].get();
            if (arrayObject == null) continue;
            ListObjectInspector arrayOI = this.argumentOIs[i];
            int arraylength = arrayOI.getListLength(arrayObject);
            for (int j = 0; j < arraylength; ++j) {
                Object rawObj = arrayOI.getListElement(arrayObject, j);
                ObjectInspector elemOI = arrayOI.getListElementObjectInspector();
                Object obj = ObjectInspectorUtils.copyToStandardObject((Object)rawObj, (ObjectInspector)elemOI);
                this.ret.add(obj);
            }
        }
        return this.ret;
    }

    public String getDisplayString(String[] children) {
        return "concat_array(" + Arrays.toString(children) + ")";
    }
}

