/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools;

import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="generate_series", value="_FUNC_(const int|bigint start, const int|bigint end) - Generate a series of values, from start to end")
public final class GenerateSeriesUDTF
extends GenericUDTF {
    private long start;
    private long end;
    private boolean useBigInt;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("Expected number of arguments is 2: " + argOIs.length);
        }
        ArrayList<String> fieldNames = new ArrayList<String>(1);
        fieldNames.add("value");
        ArrayList<Object> fieldOIs = new ArrayList<Object>(1);
        this.useBigInt = HiveUtils.isBigIntOI(argOIs[1]);
        if (this.useBigInt) {
            fieldOIs.add(PrimitiveObjectInspectorFactory.javaLongObjectInspector);
        } else {
            fieldOIs.add(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        }
        this.start = HiveUtils.getAsConstLong(argOIs[0]);
        this.end = HiveUtils.getAsConstLong(argOIs[1]);
        if (this.start > this.end) {
            throw new UDFArgumentException("start '" + this.start + "' must be less than or equlas to end '" + this.end + "'");
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] argOIs) throws HiveException {
        Object[] forwardObjs = new Object[1];
        if (this.useBigInt) {
            if (this.start == this.end) {
                forwardObjs[0] = this.start;
                this.forward(forwardObjs);
            } else {
                for (long i = this.start; i <= this.end; ++i) {
                    forwardObjs[0] = i;
                    this.forward(forwardObjs);
                }
            }
        } else {
            int starti = (int)this.start;
            int endi = (int)this.end;
            if (starti == endi) {
                forwardObjs[0] = starti;
                this.forward(forwardObjs);
            } else {
                for (int i = starti; i <= endi; ++i) {
                    forwardObjs[0] = i;
                    this.forward(forwardObjs);
                }
            }
        }
    }

    public void close() throws HiveException {
    }
}

