/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.tools;

import hivemall.utils.collections.IntArrayList;
import hivemall.utils.lang.Counter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;

@Description(name="rf_ensemble", value="_FUNC_(int y) - Returns emsebled prediction results of Random Forest classifiers")
public final class RandomForestEnsembleUDAF
extends UDAF {

    public static final class Result {
        private Integer label;
        private Double probability;
        private List<Double> probabilities;

        Result(Counter<Integer> partial) {
            Map<Integer, Integer> counts = partial.getMap();
            int size = counts.size();
            assert (size > 0) : size;
            IntArrayList keyList = new IntArrayList(size);
            long totalCnt = 0L;
            Integer maxKey = null;
            int maxCnt = Integer.MIN_VALUE;
            for (Map.Entry<Integer, Integer> e : counts.entrySet()) {
                Integer key = e.getKey();
                keyList.add(key);
                int cnt = e.getValue();
                totalCnt += (long)cnt;
                if (cnt < maxCnt) continue;
                maxCnt = cnt;
                maxKey = key;
            }
            int[] keyArray = keyList.toArray();
            Arrays.sort(keyArray);
            int last = keyArray[keyArray.length - 1];
            double totalCnt_d = totalCnt;
            Double[] probabilities = new Double[Math.max(2, last + 1)];
            int len = probabilities.length;
            for (int i = 0; i < len; ++i) {
                Integer cnt = counts.get(i);
                probabilities[i] = cnt == null ? Double.valueOf(0.0) : Double.valueOf((double)cnt.intValue() / totalCnt_d);
            }
            this.label = maxKey;
            this.probability = (double)maxCnt / totalCnt_d;
            this.probabilities = Arrays.asList(probabilities);
        }
    }

    public static class RandomForestPredictUDAFEvaluator
    implements UDAFEvaluator {
        private Counter<Integer> partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(Integer k) {
            if (k == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new Counter();
            }
            this.partial.increment(k);
            return true;
        }

        public Map<Integer, Integer> terminatePartial() {
            if (this.partial == null) {
                return null;
            }
            if (this.partial.size() == 0) {
                return null;
            }
            return this.partial.getMap();
        }

        public boolean merge(Map<Integer, Integer> o) {
            if (o == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new Counter();
            }
            this.partial.addAll(o);
            return true;
        }

        public Result terminate() {
            if (this.partial == null) {
                return null;
            }
            if (this.partial.size() == 0) {
                return null;
            }
            return new Result(this.partial);
        }
    }
}

