/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class Attribute {
    public final AttributeType type;
    public final int attrIndex;

    Attribute(AttributeType type, int attrIndex) {
        this.type = type;
        this.attrIndex = attrIndex;
    }

    public void setSize(int size) {
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        throw new UnsupportedOperationException();
    }

    public void writeTo(ObjectOutput out) throws IOException {
        out.writeInt(this.type.getTypeId());
        out.writeInt(this.attrIndex);
    }

    public static Attribute readFrom(ObjectInput in) throws IOException {
        Attribute attr;
        int typeId = in.readInt();
        int attrIndex = in.readInt();
        AttributeType type = AttributeType.resolve(typeId);
        switch (type) {
            case NUMERIC: {
                attr = new NumericAttribute(attrIndex);
                break;
            }
            case NOMINAL: {
                attr = new NominalAttribute(attrIndex);
                int size = in.readInt();
                attr.setSize(size);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)type));
            }
        }
        return attr;
    }

    public static final class NominalAttribute
    extends Attribute {
        private int size = -1;

        public NominalAttribute(int attrIndex) {
            super(AttributeType.NOMINAL, attrIndex);
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void setSize(int size) {
            this.size = size;
        }

        @Override
        public void writeTo(ObjectOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.size);
        }

        public String toString() {
            return "NominalAttribute [size=" + this.size + ", type=" + (Object)((Object)this.type) + ", attrIndex=" + this.attrIndex + "]";
        }
    }

    public static final class NumericAttribute
    extends Attribute {
        public NumericAttribute(int attrIndex) {
            super(AttributeType.NUMERIC, attrIndex);
        }

        public String toString() {
            return "NumericAttribute [type=" + (Object)((Object)this.type) + ", attrIndex=" + this.attrIndex + "]";
        }
    }

    public static enum AttributeType {
        NUMERIC(1),
        NOMINAL(2);

        private final int id;

        private AttributeType(int id) {
            this.id = id;
        }

        public int getTypeId() {
            return this.id;
        }

        public static AttributeType resolve(int id) {
            AttributeType type;
            switch (id) {
                case 1: {
                    type = NUMERIC;
                    break;
                }
                case 2: {
                    type = NOMINAL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected type: " + id);
                }
            }
            return type;
        }
    }
}

