/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile.classification;

import hivemall.UDTFWithOptions;
import hivemall.smile.ModelType;
import hivemall.smile.data.Attribute;
import hivemall.smile.regression.RegressionTree;
import hivemall.smile.utils.SmileExtUtils;
import hivemall.utils.codec.Base91;
import hivemall.utils.codec.DeflateCodec;
import hivemall.utils.collections.IntArrayList;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.io.IOUtils;
import hivemall.utils.lang.Primitives;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.Reporter;
import smile.math.Math;
import smile.math.Random;

@Description(name="train_gradient_tree_boosting_classifier", value="_FUNC_(double[] features, int label [, string options]) - Returns a relation consists of <int iteration, int model_type, array<string> pred_models, double intercept, double shrinkage, array<double> var_importance, float oob_error_rate>")
public final class GradientTreeBoostingClassifierUDTF
extends UDTFWithOptions {
    private static final Log logger = LogFactory.getLog(GradientTreeBoostingClassifierUDTF.class);
    private ListObjectInspector featureListOI;
    private PrimitiveObjectInspector featureElemOI;
    private PrimitiveObjectInspector labelOI;
    private List<double[]> featuresList;
    private IntArrayList labels;
    private int _numTrees;
    private double _eta;
    private double _subsample = 0.7;
    private float _numVars;
    private int _maxDepth;
    private int _maxLeafNodes;
    private int _minSamplesSplit;
    private int _minSamplesLeaf;
    private long _seed;
    private Attribute[] _attributes;
    private ModelType _outputType;
    @Nullable
    private Reporter _progressReporter;
    @Nullable
    private Counters.Counter _iterationCounter;

    @Override
    protected Options getOptions() {
        Options opts = new Options();
        opts.addOption("trees", "num_trees", true, "The number of trees for each task [default: 500]");
        opts.addOption("eta", "learning_rate", true, "The learning rate (0, 1]  of procedure [default: 0.05]");
        opts.addOption("subsample", "sampling_frac", true, "The fraction of samples to be used for fitting the individual base learners [default: 0.7]");
        opts.addOption("vars", "num_variables", true, "The number of random selected features [default: ceil(sqrt(x[0].length))]. int(num_variables * x[0].length) is considered if num_variable is (0,1]");
        opts.addOption("depth", "max_depth", true, "The maximum number of the tree depth [default: 8]");
        opts.addOption("leafs", "max_leaf_nodes", true, "The maximum number of leaf nodes [default: Integer.MAX_VALUE]");
        opts.addOption("splits", "min_split", true, "A node that has greater than or equals to `min_split` examples will split [default: 5]");
        opts.addOption("min_samples_leaf", true, "The minimum number of samples in a leaf node [default: 1]");
        opts.addOption("seed", true, "seed value in long [default: -1 (random)]");
        opts.addOption("attrs", "attribute_types", true, "Comma separated attribute types (Q for quantitative variable and C for categorical variable. e.g., [Q,C,Q,C])");
        opts.addOption("output", "output_type", true, "The output type (serialization/ser or opscode/vm or javascript/js) [default: serialization]");
        opts.addOption("disable_compression", false, "Whether to disable compression of the output script [default: false]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        int trees = 500;
        int maxDepth = 8;
        int maxLeafs = Integer.MAX_VALUE;
        int minSplit = 5;
        int minSamplesLeaf = 1;
        float numVars = -1.0f;
        double eta = 0.05;
        double subsample = 0.7;
        Attribute[] attrs = null;
        long seed = -1L;
        String output = "serialization";
        boolean compress = true;
        CommandLine cl = null;
        if (argOIs.length >= 3) {
            String rawArgs = HiveUtils.getConstString(argOIs[2]);
            cl = this.parseOptions(rawArgs);
            trees = Primitives.parseInt(cl.getOptionValue("num_trees"), trees);
            if (trees < 1) {
                throw new IllegalArgumentException("Invlaid number of trees: " + trees);
            }
            eta = Primitives.parseDouble(cl.getOptionValue("learning_rate"), eta);
            subsample = Primitives.parseDouble(cl.getOptionValue("subsample"), subsample);
            numVars = Primitives.parseFloat(cl.getOptionValue("num_variables"), numVars);
            maxDepth = Primitives.parseInt(cl.getOptionValue("max_depth"), maxDepth);
            maxLeafs = Primitives.parseInt(cl.getOptionValue("max_leaf_nodes"), maxLeafs);
            minSplit = Primitives.parseInt(cl.getOptionValue("min_split"), minSplit);
            minSamplesLeaf = Primitives.parseInt(cl.getOptionValue("min_samples_leaf"), minSamplesLeaf);
            seed = Primitives.parseLong(cl.getOptionValue("seed"), seed);
            attrs = SmileExtUtils.resolveAttributes(cl.getOptionValue("attribute_types"));
            output = cl.getOptionValue("output", output);
            if (cl.hasOption("disable_compression")) {
                compress = false;
            }
        }
        this._numTrees = trees;
        this._eta = eta;
        this._subsample = subsample;
        this._numVars = numVars;
        this._maxDepth = maxDepth;
        this._maxLeafNodes = maxLeafs;
        this._minSamplesSplit = minSplit;
        this._minSamplesLeaf = minSamplesLeaf;
        this._seed = seed;
        this._attributes = attrs;
        this._outputType = ModelType.resolve(output, compress);
        return cl;
    }

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2 && argOIs.length != 3) {
            throw new UDFArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " takes 2 or 3 arguments: double[] features, int label [, const string options]: " + argOIs.length);
        }
        ListObjectInspector listOI = HiveUtils.asListOI(argOIs[0]);
        ObjectInspector elemOI = listOI.getListElementObjectInspector();
        this.featureListOI = listOI;
        this.featureElemOI = HiveUtils.asDoubleCompatibleOI(elemOI);
        this.labelOI = HiveUtils.asIntCompatibleOI(argOIs[1]);
        this.processOptions(argOIs);
        this.featuresList = new ArrayList<double[]>(1024);
        this.labels = new IntArrayList(1024);
        ArrayList<String> fieldNames = new ArrayList<String>(6);
        ArrayList<Object> fieldOIs = new ArrayList<Object>(6);
        fieldNames.add("iteration");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldNames.add("model_type");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldNames.add("pred_models");
        fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector));
        fieldNames.add("intercept");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        fieldNames.add("shrinkage");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        fieldNames.add("var_importance");
        fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
        fieldNames.add("oob_error_rate");
        fieldOIs.add(PrimitiveObjectInspectorFactory.writableFloatObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        if (args[0] == null) {
            throw new HiveException("array<double> features was null");
        }
        double[] features = HiveUtils.asDoubleArray(args[0], this.featureListOI, this.featureElemOI);
        int label = PrimitiveObjectInspectorUtils.getInt((Object)args[1], (PrimitiveObjectInspector)this.labelOI);
        this.featuresList.add(features);
        this.labels.add(label);
    }

    public void close() throws HiveException {
        this._progressReporter = this.getReporter();
        this._iterationCounter = this._progressReporter == null ? null : this._progressReporter.getCounter("hivemall.smile.GradientTreeBoostingClassifier$Counter", "iteration");
        GradientTreeBoostingClassifierUDTF.reportProgress(this._progressReporter);
        int numExamples = this.featuresList.size();
        double[][] x = (double[][])this.featuresList.toArray((T[])new double[numExamples][]);
        this.featuresList = null;
        int[] y = this.labels.toArray();
        this.labels = null;
        this.train(x, y);
        this.featureListOI = null;
        this.featureElemOI = null;
        this.labelOI = null;
        this._attributes = null;
    }

    private void checkOptions() throws HiveException {
        if (this._eta <= 0.0 || this._eta > 1.0) {
            throw new HiveException("Invalid shrinkage: " + this._eta);
        }
        if (this._subsample <= 0.0 || this._subsample > 1.0) {
            throw new HiveException("Invalid sampling fraction: " + this._subsample);
        }
        if (this._minSamplesSplit <= 0) {
            throw new HiveException("Invalid minSamplesSplit: " + this._minSamplesSplit);
        }
        if (this._maxDepth < 1) {
            throw new HiveException("Invalid maxDepth: " + this._maxDepth);
        }
    }

    private void train(@Nonnull double[][] x, @Nonnull int[] y) throws HiveException {
        if (x.length != y.length) {
            throw new HiveException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        this.checkOptions();
        this._attributes = SmileExtUtils.attributeTypes(this._attributes, x);
        SmileExtUtils.shuffle(x, y, this._seed);
        int k = Math.max(y) + 1;
        if (k < 2) {
            throw new UDFArgumentException("Only one class or negative class labels.");
        }
        if (k == 2) {
            int n = x.length;
            int[] y2 = new int[n];
            for (int i = 0; i < n; ++i) {
                y2[i] = y[i] == 1 ? 1 : -1;
            }
            this.train2(x, y2);
        } else {
            this.traink(x, y, k);
        }
    }

    private void train2(@Nonnull double[][] x, @Nonnull int[] y) throws HiveException {
        int numVars = SmileExtUtils.computeNumInputVars(this._numVars, x);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("k: 2, numTrees: " + this._numTrees + ", shirinkage: " + this._eta + ", subsample: " + this._subsample + ", numVars: " + numVars + ", maxDepth: " + this._maxDepth + ", minSamplesSplit: " + this._minSamplesSplit + ", maxLeafs: " + this._maxLeafNodes + ", seed: " + this._seed));
        }
        int numInstances = x.length;
        int numSamples = (int)java.lang.Math.round((double)numInstances * this._subsample);
        double[] h = new double[numInstances];
        double[] response = new double[numInstances];
        double mu = Math.mean(y);
        double intercept = 0.5 * java.lang.Math.log((1.0 + mu) / (1.0 - mu));
        for (int i = 0; i < numInstances; ++i) {
            h[i] = intercept;
        }
        int[][] order = SmileExtUtils.sort(this._attributes, x);
        L2NodeOutput output = new L2NodeOutput(response);
        BitSet sampled = new BitSet(numInstances);
        int[] bag = new int[numSamples];
        int[] perm = new int[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            perm[i] = i;
        }
        long s = this._seed == -1L ? SmileExtUtils.generateSeed() : new Random(this._seed).nextLong();
        Random rnd1 = new Random(s);
        Random rnd2 = new Random(rnd1.nextLong());
        for (int m = 0; m < this._numTrees; ++m) {
            int i;
            GradientTreeBoostingClassifierUDTF.reportProgress(this._progressReporter);
            SmileExtUtils.shuffle(perm, rnd1);
            for (i = 0; i < numSamples; ++i) {
                int index;
                bag[i] = index = perm[i];
                sampled.set(index);
            }
            for (i = 0; i < numInstances; ++i) {
                response[i] = 2.0 * (double)y[i] / (1.0 + java.lang.Math.exp(2.0 * (double)y[i] * h[i]));
            }
            RegressionTree tree = new RegressionTree(this._attributes, x, response, numVars, this._maxDepth, this._maxLeafNodes, this._minSamplesSplit, this._minSamplesLeaf, order, bag, output, rnd2);
            for (int i2 = 0; i2 < numInstances; ++i2) {
                int n = i2;
                h[n] = h[n] + this._eta * tree.predict(x[i2]);
            }
            int oobTests = 0;
            int oobErrors = 0;
            int i3 = sampled.nextClearBit(0);
            while (i3 < numInstances) {
                int pred;
                ++oobTests;
                int n = pred = h[i3] > 0.0 ? 1 : 0;
                if (pred != y[i3]) {
                    ++oobErrors;
                }
                i3 = sampled.nextClearBit(i3 + 1);
            }
            float oobErrorRate = 0.0f;
            if (oobTests > 0) {
                oobErrorRate = (float)oobErrors / (float)oobTests;
            }
            this.forward(m + 1, intercept, this._eta, oobErrorRate, tree);
            sampled.clear();
        }
    }

    private void traink(double[][] x, int[] y, int k) throws HiveException {
        int numVars = SmileExtUtils.computeNumInputVars(this._numVars, x);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("k: " + k + ", numTrees: " + this._numTrees + ", shirinkage: " + this._eta + ", subsample: " + this._subsample + ", numVars: " + numVars + ", minSamplesSplit: " + this._minSamplesSplit + ", maxDepth: " + this._maxDepth + ", maxLeafs: " + this._maxLeafNodes + ", seed: " + this._seed));
        }
        int numInstances = x.length;
        int numSamples = (int)java.lang.Math.round((double)numInstances * this._subsample);
        double[][] h = new double[k][numInstances];
        double[][] p = new double[k][numInstances];
        double[][] response = new double[k][numInstances];
        int[][] order = SmileExtUtils.sort(this._attributes, x);
        LKNodeOutput[] output = new LKNodeOutput[k];
        for (int i = 0; i < k; ++i) {
            output[i] = new LKNodeOutput(response[i], k);
        }
        BitSet sampled = new BitSet(numInstances);
        int[] bag = new int[numSamples];
        int[] perm = new int[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            perm[i] = i;
        }
        long s = this._seed == -1L ? SmileExtUtils.generateSeed() : new Random(this._seed).nextLong();
        Random rnd1 = new Random(s);
        Random rnd2 = new Random(rnd1.nextLong());
        int[] prediction = new int[numInstances];
        for (int m = 0; m < this._numTrees; ++m) {
            int j;
            for (int i = 0; i < numInstances; ++i) {
                double max = Double.NEGATIVE_INFINITY;
                for (int j2 = 0; j2 < k; ++j2) {
                    double h_ji = h[j2][i];
                    if (!(max < h_ji)) continue;
                    max = h_ji;
                }
                double Z = 0.0;
                for (j = 0; j < k; ++j) {
                    double p_ji;
                    p[j][i] = p_ji = java.lang.Math.exp(h[j][i] - max);
                    Z += p_ji;
                }
                for (j = 0; j < k; ++j) {
                    double[] dArray = p[j];
                    int n = i;
                    dArray[n] = dArray[n] / Z;
                }
            }
            RegressionTree[] trees = new RegressionTree[k];
            Arrays.fill(prediction, -1);
            double max_h = Double.NEGATIVE_INFINITY;
            int oobTests = 0;
            int oobErrors = 0;
            for (j = 0; j < k; ++j) {
                RegressionTree tree;
                int i;
                GradientTreeBoostingClassifierUDTF.reportProgress(this._progressReporter);
                double[] response_j = response[j];
                double[] p_j = p[j];
                double[] h_j = h[j];
                for (i = 0; i < numInstances; ++i) {
                    response_j[i] = y[i] == j ? 1.0 : 0.0;
                    int n = i;
                    response_j[n] = response_j[n] - p_j[i];
                }
                SmileExtUtils.shuffle(perm, rnd1);
                for (i = 0; i < numSamples; ++i) {
                    int index;
                    bag[i] = index = perm[i];
                    sampled.set(i);
                }
                trees[j] = tree = new RegressionTree(this._attributes, x, response[j], numVars, this._maxDepth, this._maxLeafNodes, this._minSamplesSplit, this._minSamplesLeaf, order, bag, output[j], rnd2);
                for (int i2 = 0; i2 < numInstances; ++i2) {
                    double h_ji = h_j[i2] + this._eta * tree.predict(x[i2]);
                    int n = i2;
                    h_j[n] = h_j[n] + h_ji;
                    if (!(h_ji > max_h)) continue;
                    max_h = h_ji;
                    prediction[i2] = j;
                }
            }
            int i = sampled.nextClearBit(0);
            while (i < numInstances) {
                ++oobTests;
                if (prediction[i] != y[i]) {
                    ++oobErrors;
                }
                i = sampled.nextClearBit(i + 1);
            }
            sampled.clear();
            float oobErrorRate = 0.0f;
            if (oobTests > 0) {
                oobErrorRate = (float)oobErrors / (float)oobTests;
            }
            this.forward(m + 1, 0.0, this._eta, oobErrorRate, trees);
        }
    }

    private void forward(int m, double intercept, double shrinkage, float oobErrorRate, RegressionTree ... trees) throws HiveException {
        Text[] models = GradientTreeBoostingClassifierUDTF.getModel(trees, this._outputType);
        double[] importance = new double[this._attributes.length];
        for (RegressionTree tree : trees) {
            double[] imp = tree.importance();
            for (int i = 0; i < imp.length; ++i) {
                int n = i;
                importance[n] = importance[n] + imp[i];
            }
        }
        Object[] forwardObjs = new Object[]{new IntWritable(m), new IntWritable(this._outputType.getId()), models, new DoubleWritable(intercept), new DoubleWritable(shrinkage), WritableUtils.toWritableList(importance), new FloatWritable(oobErrorRate)};
        this.forward(forwardObjs);
        GradientTreeBoostingClassifierUDTF.reportProgress(this._progressReporter);
        GradientTreeBoostingClassifierUDTF.incrCounter(this._iterationCounter, 1L);
        logger.info((Object)("Forwarded the output of " + m + "-th Boosting iteration out of " + this._numTrees));
    }

    /*
     * Unable to fully structure code
     */
    private static Text[] getModel(@Nonnull RegressionTree[] trees, @Nonnull ModelType outputType) throws HiveException {
        m = trees.length;
        models = new Text[m];
        switch (1.$SwitchMap$hivemall$smile$ModelType[outputType.ordinal()]) {
            case 1: 
            case 2: {
                for (i = 0; i < m; ++i) {
                    b = trees[i].predictSerCodegen(outputType.isCompressed());
                    b = Base91.encode(b);
                    models[i] = new Text(b);
                }
                break;
            }
            case 3: 
            case 4: {
                for (i = 0; i < m; ++i) {
                    s = trees[i].predictOpCodegen("; ");
                    if (!outputType.isCompressed()) ** GOTO lbl28
                    b = s.getBytes();
                    codec = new DeflateCodec(true, false);
                    try {
                        b = codec.compress(b);
                    }
                    catch (IOException e) {
                        throw new HiveException("Failed to compressing a model", (Throwable)e);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)codec);
                    }
                    b = Base91.encode(b);
                    models[i] = new Text(b);
                    continue;
lbl28:
                    // 1 sources

                    models[i] = new Text(s);
                }
                break;
            }
            case 5: 
            case 6: {
                for (i = 0; i < m; ++i) {
                    s = trees[i].predictJsCodegen();
                    if (!outputType.isCompressed()) ** GOTO lbl48
                    b = s.getBytes();
                    codec = new DeflateCodec(true, false);
                    try {
                        b = codec.compress(b);
                    }
                    catch (IOException e) {
                        throw new HiveException("Failed to compressing a model", (Throwable)e);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)codec);
                    }
                    b = Base91.encode(b);
                    models[i] = new Text(b);
                    continue;
lbl48:
                    // 1 sources

                    models[i] = new Text(s);
                }
                break;
            }
            default: {
                throw new HiveException("Unexpected output type: " + (Object)outputType + ". Use javascript for the output instead");
            }
        }
        return models;
    }

    private static final class LKNodeOutput
    implements RegressionTree.NodeOutput {
        final double[] y;
        final double k;

        public LKNodeOutput(double[] response, int k) {
            this.y = response;
            this.k = k;
        }

        @Override
        public double calculate(int[] samples) {
            int n = 0;
            double nu = 0.0;
            double de = 0.0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                ++n;
                double y_i = this.y[i];
                double abs = java.lang.Math.abs(y_i);
                nu += y_i;
                de += abs * (1.0 - abs);
            }
            if (de < 1.0E-10) {
                return nu / (double)n;
            }
            return (this.k - 1.0) / this.k * (nu / de);
        }
    }

    private static final class L2NodeOutput
    implements RegressionTree.NodeOutput {
        final double[] y;

        public L2NodeOutput(double[] y) {
            this.y = y;
        }

        @Override
        public double calculate(int[] samples) {
            double nu = 0.0;
            double de = 0.0;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                double y_i = this.y[i];
                double abs = java.lang.Math.abs(y_i);
                nu += y_i;
                de += abs * (2.0 - abs);
            }
            return nu / de;
        }
    }
}

