/*
 * Decompiled with CFR 0.152.
 */
package hivemall.smile;

public enum ModelType {
    opscode(1, false),
    javascript(2, false),
    serialization(3, false),
    opscode_compressed(-1, true),
    javascript_compressed(-2, true),
    serialization_compressed(-3, true);

    private final int id;
    private final boolean compressed;

    private ModelType(int id, boolean compressed) {
        this.id = id;
        this.compressed = compressed;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public static ModelType resolve(String name, boolean compressed) {
        if ("opscode".equals(name = name.toLowerCase()) || "vm".equals(name)) {
            return compressed ? opscode_compressed : opscode;
        }
        if ("javascript".equals(name) || "js".equals(name)) {
            return compressed ? javascript_compressed : javascript;
        }
        if ("serialization".equals(name) || "ser".equals(name)) {
            return compressed ? serialization_compressed : serialization;
        }
        throw new IllegalStateException("Unexpected output type: " + name);
    }

    public static ModelType resolve(int id) {
        ModelType type;
        switch (id) {
            case 1: {
                type = opscode;
                break;
            }
            case -1: {
                type = opscode_compressed;
                break;
            }
            case 2: {
                type = javascript;
                break;
            }
            case -2: {
                type = javascript_compressed;
                break;
            }
            case 3: {
                type = serialization;
                break;
            }
            case -3: {
                type = serialization_compressed;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ID for ModelType: " + id);
            }
        }
        return type;
    }
}

