/*
 * Decompiled with CFR 0.152.
 */
package hivemall.regression;

import hivemall.common.LossFunctions;
import hivemall.model.FeatureValue;
import hivemall.model.IWeightValue;
import hivemall.model.WeightValue;
import hivemall.regression.RegressionBaseUDTF;
import hivemall.utils.lang.Primitives;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="train_adadelta_regr", value="_FUNC_(array<int|bigint|string> features, float target [, constant string options]) - Returns a relation consists of <{int|bigint|string} feature, float weight>")
public final class AdaDeltaUDTF
extends RegressionBaseUDTF {
    private float decay;
    private float eps;
    private float scaling;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgs = argOIs.length;
        if (numArgs != 2 && numArgs != 3) {
            throw new UDFArgumentException("AdaDeltaUDTF takes 2 or 3 arguments: List<Text|Int|BitInt> features, float target [, constant string options]");
        }
        StructObjectInspector oi = super.initialize(argOIs);
        this.model.configureParams(true, true, false);
        return oi;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("rho", "decay", true, "Decay rate [default 0.95]");
        opts.addOption("eps", true, "A constant used in the denominator of AdaGrad [default 1e-6]");
        opts.addOption("scale", true, "Internal scaling/descaling factor for cumulative weights [100]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        if (cl == null) {
            this.decay = 0.95f;
            this.eps = 1.0E-6f;
            this.scaling = 100.0f;
        } else {
            this.decay = Primitives.parseFloat(cl.getOptionValue("decay"), 0.95f);
            this.eps = Primitives.parseFloat(cl.getOptionValue("eps"), 1.0E-6f);
            this.scaling = Primitives.parseFloat(cl.getOptionValue("scale"), 100.0f);
        }
        return cl;
    }

    @Override
    protected final void checkTargetValue(float target) throws UDFArgumentException {
        if (target < 0.0f || target > 1.0f) {
            throw new UDFArgumentException("target must be in range 0 to 1: " + target);
        }
    }

    @Override
    protected void update(@Nonnull FeatureValue[] features, float target, float predicted) {
        float gradient = LossFunctions.logisticLoss(target, predicted);
        this.onlineUpdate(features, gradient);
    }

    @Override
    protected void onlineUpdate(@Nonnull FeatureValue[] features, float gradient) {
        float g_g = gradient * (gradient / this.scaling);
        for (FeatureValue f : features) {
            if (f == null) continue;
            Object x = f.getFeature();
            float xi = f.getValueAsFloat();
            Object old_w = this.model.get(x);
            IWeightValue new_w = this.getNewWeight((IWeightValue)old_w, xi, gradient, g_g);
            this.model.set(x, new_w);
        }
    }

    @Nonnull
    protected IWeightValue getNewWeight(@Nullable IWeightValue old, float xi, float gradient, float g_g) {
        float old_w = 0.0f;
        float old_scaled_sum_sqgrad = 0.0f;
        float old_sum_squared_delta_x = 0.0f;
        if (old != null) {
            old_w = old.get();
            old_scaled_sum_sqgrad = old.getSumOfSquaredGradients();
            old_sum_squared_delta_x = old.getSumOfSquaredDeltaX();
        }
        float new_scaled_sum_sq_grad = this.decay * old_scaled_sum_sqgrad + (1.0f - this.decay) * g_g;
        float dx = (float)Math.sqrt((old_sum_squared_delta_x + this.eps) / (old_scaled_sum_sqgrad * this.scaling + this.eps)) * gradient;
        float new_sum_squared_delta_x = this.decay * old_sum_squared_delta_x + (1.0f - this.decay) * dx * dx;
        float new_w = old_w + dx * xi;
        return new WeightValue.WeightValueParamsF2(new_w, new_scaled_sum_sq_grad, new_sum_squared_delta_x);
    }
}

