/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.model.IWeightValue;
import javax.annotation.Nonnegative;

public class WeightValueWithClock
implements IWeightValue {
    protected float value;
    protected short clock;
    protected byte deltaUpdates;

    public WeightValueWithClock(float value) {
        this.value = value;
        this.clock = 0;
        this.deltaUpdates = 0;
    }

    public WeightValueWithClock(IWeightValue src) {
        this.value = src.get();
        if (src.isTouched()) {
            this.clock = 1;
            this.deltaUpdates = 1;
        } else {
            this.clock = 0;
            this.deltaUpdates = 0;
        }
    }

    @Override
    public IWeightValue.WeightValueType getType() {
        return IWeightValue.WeightValueType.NoParams;
    }

    @Override
    public float getFloatParams(@Nonnegative int i) {
        throw new UnsupportedOperationException("getFloatParams(int) should not be called");
    }

    @Override
    public final float get() {
        return this.value;
    }

    @Override
    public final void set(float weight) {
        this.value = weight;
    }

    @Override
    public boolean hasCovariance() {
        return false;
    }

    @Override
    public float getCovariance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCovariance(float cov) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getSumOfSquaredGradients() {
        return 0.0f;
    }

    @Override
    public float getSumOfSquaredDeltaX() {
        return 0.0f;
    }

    @Override
    public float getSumOfGradients() {
        return 0.0f;
    }

    @Override
    public final boolean isTouched() {
        return this.deltaUpdates > 0;
    }

    @Override
    public void setTouched(boolean touched) {
        throw new UnsupportedOperationException("WeightValueWithClock#setTouched should not be called");
    }

    @Override
    public final short getClock() {
        return this.clock;
    }

    @Override
    public final void setClock(short clock) {
        this.clock = clock;
    }

    @Override
    public final byte getDeltaUpdates() {
        return this.deltaUpdates;
    }

    @Override
    public final void setDeltaUpdates(byte deltaUpdates) {
        if (deltaUpdates < 0) {
            throw new IllegalArgumentException("deltaUpdates is less than 0: " + deltaUpdates);
        }
        this.deltaUpdates = deltaUpdates;
    }

    @Override
    public void copyTo(IWeightValue another) {
        another.set(this.value);
        another.setClock(this.clock);
        another.setDeltaUpdates(this.deltaUpdates);
    }

    @Override
    public void copyFrom(IWeightValue another) {
        this.value = another.get();
        this.clock = another.getClock();
        this.deltaUpdates = another.getDeltaUpdates();
    }

    public String toString() {
        return "WeightValueWithClock [value=" + this.value + ", clock=" + this.clock + ", deltaUpdates=" + this.deltaUpdates + "]";
    }

    public static final class WeightValueWithCovarClock
    extends WeightValueWithClock {
        public static final float DEFAULT_COVAR = 1.0f;
        private float covariance;

        public WeightValueWithCovarClock(float value, float covar) {
            super(value);
            this.covariance = covar;
        }

        public WeightValueWithCovarClock(IWeightValue src) {
            super(src);
            this.covariance = src.getCovariance();
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsCovar;
        }

        @Override
        public boolean hasCovariance() {
            return true;
        }

        @Override
        public float getCovariance() {
            return this.covariance;
        }

        @Override
        public void setCovariance(float cov) {
            this.covariance = cov;
        }

        @Override
        public void copyTo(IWeightValue another) {
            super.copyTo(another);
            another.setCovariance(this.covariance);
        }

        @Override
        public void copyFrom(IWeightValue another) {
            super.copyFrom(another);
            this.covariance = another.getCovariance();
        }

        @Override
        public String toString() {
            return "WeightValueWithCovar [value=" + this.value + ", clock=" + this.clock + ", deltaUpdates=" + this.deltaUpdates + ", covariance=" + this.covariance + "]";
        }
    }

    public static final class WeightValueParamsF2Clock
    extends WeightValueWithClock {
        private final float f1;
        private final float f2;

        public WeightValueParamsF2Clock(float value, float f1, float f2) {
            super(value);
            this.f1 = f1;
            this.f2 = f2;
        }

        public WeightValueParamsF2Clock(IWeightValue src) {
            super(src);
            this.f1 = src.getFloatParams(1);
            this.f2 = src.getFloatParams(2);
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsF2;
        }

        @Override
        public float getFloatParams(@Nonnegative int i) {
            if (i == 1) {
                return this.f1;
            }
            if (i == 2) {
                return this.f2;
            }
            throw new IllegalArgumentException("getFloatParams(" + i + ") should not be called");
        }

        @Override
        public float getSumOfSquaredGradients() {
            return this.f1;
        }

        @Override
        public float getSumOfSquaredDeltaX() {
            return this.f2;
        }

        @Override
        public float getSumOfGradients() {
            return this.f2;
        }
    }

    public static final class WeightValueParamsF1Clock
    extends WeightValueWithClock {
        private final float f1;

        public WeightValueParamsF1Clock(float value, float f1) {
            super(value);
            this.f1 = f1;
        }

        public WeightValueParamsF1Clock(IWeightValue src) {
            super(src);
            this.f1 = src.getFloatParams(1);
        }

        @Override
        public IWeightValue.WeightValueType getType() {
            return IWeightValue.WeightValueType.ParamsF1;
        }

        @Override
        public float getFloatParams(@Nonnegative int i) {
            if (i == 1) {
                return this.f1;
            }
            throw new IllegalArgumentException("getFloatParams(" + i + ") should not be called");
        }

        @Override
        public float getSumOfSquaredGradients() {
            return this.f1;
        }
    }
}

