/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.model.IWeightValue;
import hivemall.model.ModelUpdateHandler;
import hivemall.model.PredictionModel;
import hivemall.utils.collections.IMapIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public final class SynchronizedModelWrapper
implements PredictionModel {
    private final PredictionModel model;
    private final Lock lock;

    public SynchronizedModelWrapper(PredictionModel model) {
        this.model = model;
        this.lock = new ReentrantLock();
    }

    public PredictionModel getModel() {
        return this.model;
    }

    @Override
    public ModelUpdateHandler getUpdateHandler() {
        return this.model.getUpdateHandler();
    }

    @Override
    public void configureMix(ModelUpdateHandler handler, boolean cancelMixRequest) {
        this.model.configureMix(handler, cancelMixRequest);
    }

    @Override
    public long getNumMixed() {
        return this.model.getNumMixed();
    }

    @Override
    public boolean hasCovariance() {
        return this.model.hasCovariance();
    }

    @Override
    public void configureParams(boolean sum_of_squared_gradients, boolean sum_of_squared_delta_x, boolean sum_of_gradients) {
        this.model.configureParams(sum_of_squared_gradients, sum_of_squared_delta_x, sum_of_gradients);
    }

    @Override
    public void configureClock() {
        this.model.configureClock();
    }

    @Override
    public boolean hasClock() {
        return this.model.hasClock();
    }

    @Override
    public <K, V extends IWeightValue> IMapIterator<K, V> entries() {
        return this.model.entries();
    }

    @Override
    public void resetDeltaUpdates(int feature) {
        try {
            this.lock.lock();
            this.model.resetDeltaUpdates(feature);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.lock.lock();
            int n = this.model.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(Object feature) {
        try {
            this.lock.lock();
            boolean bl = this.model.contains(feature);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T extends IWeightValue> T get(Object feature) {
        try {
            this.lock.lock();
            Object t = this.model.get(feature);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T extends IWeightValue> void set(Object feature, T value) {
        try {
            this.lock.lock();
            this.model.set(feature, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void delete(@Nonnull Object feature) {
        try {
            this.lock.lock();
            this.model.delete(feature);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public float getWeight(Object feature) {
        try {
            this.lock.lock();
            float f = this.model.getWeight(feature);
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public float getCovariance(Object feature) {
        try {
            this.lock.lock();
            float f = this.model.getCovariance(feature);
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(@Nonnull Object feature, float weight, float covar, short clock) {
        try {
            this.lock.lock();
            this.model.set(feature, weight, covar, clock);
        }
        finally {
            this.lock.unlock();
        }
    }
}

