/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import hivemall.model.AbstractPredictionModel;
import hivemall.model.IWeightValue;
import hivemall.model.WeightValueWithClock;
import hivemall.utils.collections.IMapIterator;
import hivemall.utils.collections.OpenHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SparseModel
extends AbstractPredictionModel {
    private static final Log logger = LogFactory.getLog(SparseModel.class);
    private final OpenHashMap<Object, IWeightValue> weights;
    private final boolean hasCovar;
    private boolean clockEnabled;

    public SparseModel(int size, boolean hasCovar) {
        this.weights = new OpenHashMap(size);
        this.hasCovar = hasCovar;
        this.clockEnabled = false;
    }

    @Override
    protected boolean isDenseModel() {
        return false;
    }

    @Override
    public boolean hasCovariance() {
        return this.hasCovar;
    }

    @Override
    public void configureParams(boolean sum_of_squared_gradients, boolean sum_of_squared_delta_x, boolean sum_of_gradients) {
    }

    @Override
    public void configureClock() {
        this.clockEnabled = true;
    }

    @Override
    public boolean hasClock() {
        return this.clockEnabled;
    }

    @Override
    public <T extends IWeightValue> T get(Object feature) {
        return (T)this.weights.get(feature);
    }

    @Override
    public <T extends IWeightValue> void set(Object feature, T value) {
        IWeightValue old;
        assert (feature != null);
        assert (value != null);
        IWeightValue wrapperValue = this.wrapIfRequired(value);
        if (this.clockEnabled && value.isTouched() && (old = this.weights.get(feature)) != null) {
            short newclock = (short)(old.getClock() + 1);
            wrapperValue.setClock(newclock);
            int newDelta = old.getDeltaUpdates() + 1;
            wrapperValue.setDeltaUpdates((byte)newDelta);
        }
        this.weights.put(feature, wrapperValue);
        this.onUpdate(feature, wrapperValue);
    }

    @Override
    public void delete(@Nonnull Object feature) {
        this.weights.remove(feature);
    }

    private IWeightValue wrapIfRequired(IWeightValue value) {
        IWeightValue wrapper;
        block7: {
            block6: {
                if (!this.clockEnabled) break block6;
                switch (value.getType()) {
                    case NoParams: {
                        wrapper = new WeightValueWithClock(value);
                        break block7;
                    }
                    case ParamsCovar: {
                        wrapper = new WeightValueWithClock.WeightValueWithCovarClock(value);
                        break block7;
                    }
                    case ParamsF1: {
                        wrapper = new WeightValueWithClock.WeightValueParamsF1Clock(value);
                        break block7;
                    }
                    case ParamsF2: {
                        wrapper = new WeightValueWithClock.WeightValueParamsF2Clock(value);
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value type: " + (Object)((Object)value.getType()));
                    }
                }
            }
            wrapper = value;
        }
        return wrapper;
    }

    @Override
    public float getWeight(Object feature) {
        IWeightValue v = this.weights.get(feature);
        return v == null ? 0.0f : v.get();
    }

    @Override
    public float getCovariance(Object feature) {
        IWeightValue v = this.weights.get(feature);
        return v == null ? 1.0f : v.getCovariance();
    }

    @Override
    protected void _set(Object feature, float weight, short clock) {
        IWeightValue w = this.weights.get(feature);
        if (w == null) {
            logger.warn((Object)("Previous weight not found: " + feature));
            throw new IllegalStateException("Previous weight not found " + feature);
        }
        w.set(weight);
        w.setClock(clock);
        w.setDeltaUpdates((byte)0);
    }

    @Override
    protected void _set(Object feature, float weight, float covar, short clock) {
        IWeightValue w = this.weights.get(feature);
        if (w == null) {
            logger.warn((Object)("Previous weight not found: " + feature));
            throw new IllegalStateException("Previous weight not found: " + feature);
        }
        w.set(weight);
        w.setCovariance(covar);
        w.setClock(clock);
        w.setDeltaUpdates((byte)0);
    }

    @Override
    public int size() {
        return this.weights.size();
    }

    @Override
    public boolean contains(Object feature) {
        return this.weights.containsKey(feature);
    }

    @Override
    public <K, V extends IWeightValue> IMapIterator<K, V> entries() {
        return this.weights.entries();
    }
}

