/*
 * Decompiled with CFR 0.152.
 */
package hivemall.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.io.Text;

public final class FeatureValue {
    private Object feature;
    private double value;

    public FeatureValue() {
    }

    public FeatureValue(Object f, float v) {
        this.feature = f;
        this.value = v;
    }

    public FeatureValue(Object f, double v) {
        this.feature = f;
        this.value = v;
    }

    public <T> T getFeature() {
        return (T)this.feature;
    }

    public double getValue() {
        return this.value;
    }

    public float getValueAsFloat() {
        return (float)this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Nullable
    public static FeatureValue parse(Object o) throws IllegalArgumentException {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        return FeatureValue.parse(s);
    }

    @Nullable
    public static FeatureValue parse(@Nonnull String s) throws IllegalArgumentException {
        double weight;
        Text feature;
        assert (s != null);
        int pos = s.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        if (pos > 0) {
            String s1 = s.substring(0, pos);
            String s2 = s.substring(pos + 1);
            feature = new Text(s1);
            weight = Double.parseDouble(s2);
        } else {
            feature = new Text(s);
            weight = 1.0;
        }
        return new FeatureValue((Object)feature, weight);
    }

    @Nonnull
    public static FeatureValue parseFeatureAsString(@Nonnull Text t) {
        String s = t.toString();
        return FeatureValue.parseFeatureAsString(s);
    }

    @Nonnull
    public static FeatureValue parseFeatureAsString(@Nonnull String s) throws IllegalArgumentException {
        double weight;
        String feature;
        assert (s != null);
        int pos = s.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        if (pos > 0) {
            feature = s.substring(0, pos);
            String s2 = s.substring(pos + 1);
            weight = Double.parseDouble(s2);
        } else {
            feature = s;
            weight = 1.0;
        }
        return new FeatureValue((Object)feature, weight);
    }

    public static void parseFeatureAsString(@Nonnull Text t, @Nonnull FeatureValue probe) {
        assert (t != null);
        String s = t.toString();
        FeatureValue.parseFeatureAsString(s, probe);
    }

    public static void parseFeatureAsString(@Nonnull String s, @Nonnull FeatureValue probe) throws IllegalArgumentException {
        assert (s != null);
        assert (probe != null);
        int pos = s.indexOf(58);
        if (pos == 0) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        if (pos > 0) {
            probe.feature = s.substring(0, pos);
            String s2 = s.substring(pos + 1);
            probe.value = Double.parseDouble(s2);
        } else {
            probe.feature = s;
            probe.value = 1.0;
        }
    }
}

