/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mix.client;

import hivemall.mix.MixMessage;
import hivemall.mix.NodeInfo;
import hivemall.utils.net.NetUtils;
import java.net.InetSocketAddress;

public final class MixRequestRouter {
    private final int numNodes;
    private final NodeInfo[] nodes;

    public MixRequestRouter(String connectInfo) {
        if (connectInfo == null) {
            throw new IllegalArgumentException();
        }
        String[] endpoints = connectInfo.split("\\s*,\\s*");
        int numEndpoints = endpoints.length;
        if (numEndpoints < 1) {
            throw new IllegalArgumentException("Invalid connectInfo: " + connectInfo);
        }
        this.numNodes = numEndpoints;
        NodeInfo[] nodes = new NodeInfo[numEndpoints];
        for (int i = 0; i < numEndpoints; ++i) {
            InetSocketAddress addr = NetUtils.getInetSocketAddress(endpoints[i], 11212);
            nodes[i] = new NodeInfo(addr);
        }
        this.nodes = nodes;
    }

    public NodeInfo[] getAllNodes() {
        return this.nodes;
    }

    public NodeInfo selectNode(MixMessage msg) {
        assert (msg != null);
        Object feature = msg.getFeature();
        int hashcode = feature.hashCode();
        int index = (hashcode & Integer.MAX_VALUE) % this.numNodes;
        return this.nodes[index];
    }
}

