/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mix.client;

import hivemall.mix.MixMessageDecoder;
import hivemall.mix.MixMessageEncoder;
import hivemall.mix.client.MixClientHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;

public final class MixClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final MixClientHandler responseHandler;
    private final SslContext sslCtx;

    public MixClientInitializer(MixClientHandler msgHandler, SslContext sslCtx) {
        if (msgHandler == null) {
            throw new IllegalArgumentException();
        }
        this.responseHandler = msgHandler;
        this.sslCtx = sslCtx;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(this.sslCtx.newHandler(ch.alloc()));
        }
        MixMessageEncoder encoder = new MixMessageEncoder();
        MixMessageDecoder decoder = new MixMessageDecoder();
        pipeline.addLast(encoder, decoder, this.responseHandler);
    }
}

