/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mix;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class NodeInfo {
    private final InetAddress addr;
    private final int port;

    public NodeInfo(InetAddress addr, int port) {
        if (addr == null) {
            throw new IllegalArgumentException("addr is null");
        }
        this.addr = addr;
        this.port = port;
    }

    public NodeInfo(InetSocketAddress sockAddr) {
        this.addr = sockAddr.getAddress();
        this.port = sockAddr.getPort();
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.addr, this.port);
    }

    public int hashCode() {
        return this.addr.hashCode() + this.port;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeInfo) {
            NodeInfo other = (NodeInfo)obj;
            return this.addr.equals(other.addr) && this.port == other.port;
        }
        return false;
    }

    public String toString() {
        return this.addr.toString() + ":" + this.port;
    }
}

