/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mix;

import hivemall.mix.MixMessage;
import hivemall.utils.lang.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public final class MixMessageEncoder
extends MessageToByteEncoder<MixMessage> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    static final byte INTEGER_TYPE = 1;
    static final byte TEXT_TYPE = 2;
    static final byte STRING_TYPE = 3;
    static final byte INT_WRITABLE_TYPE = 4;
    static final byte LONG_WRITABLE_TYPE = 5;

    public MixMessageEncoder() {
        super(MixMessage.class, true);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, MixMessage msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        out.writeBytes(LENGTH_PLACEHOLDER);
        MixMessage.MixEventName event = msg.getEvent();
        byte b = event.getID();
        out.writeByte(b);
        Object feature = msg.getFeature();
        MixMessageEncoder.encodeObject(feature, out);
        float weight = msg.getWeight();
        out.writeFloat(weight);
        float covariance = msg.getCovariance();
        out.writeFloat(covariance);
        short clock = msg.getClock();
        out.writeShort(clock);
        int deltaUpdates = msg.getDeltaUpdates();
        out.writeInt(deltaUpdates);
        boolean cancelRequest = msg.isCancelRequest();
        out.writeBoolean(cancelRequest);
        String groupId = msg.getGroupID();
        MixMessageEncoder.writeString(groupId, out);
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }

    private static void encodeObject(Object obj, ByteBuf buf) throws IOException {
        assert (obj != null);
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            buf.writeByte(1);
            buf.writeInt(i);
        } else if (obj instanceof Text) {
            Text t = (Text)obj;
            byte[] b = t.getBytes();
            int length = t.getLength();
            buf.writeByte(2);
            buf.writeInt(length);
            buf.writeBytes(b, 0, length);
        } else if (obj instanceof String) {
            String s = (String)obj;
            buf.writeByte(3);
            MixMessageEncoder.writeString(s, buf);
        } else if (obj instanceof IntWritable) {
            IntWritable i = (IntWritable)obj;
            buf.writeByte(4);
            buf.writeInt(i.get());
        } else if (obj instanceof LongWritable) {
            LongWritable l = (LongWritable)obj;
            buf.writeByte(5);
            buf.writeLong(l.get());
        } else {
            throw new IllegalStateException("Unexpected type: " + obj.getClass().getName());
        }
    }

    private static void writeString(String s, ByteBuf buf) {
        if (s == null) {
            buf.writeInt(-1);
            return;
        }
        byte[] b = StringUtils.getBytes(s);
        int length = b.length;
        buf.writeInt(length);
        buf.writeBytes(b, 0, length);
    }
}

