/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mix;

import hivemall.mix.MixMessage;
import hivemall.utils.lang.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public final class MixMessageDecoder
extends LengthFieldBasedFrameDecoder {
    public MixMessageDecoder() {
        super(0x100000, 0, 4, 0, 4);
    }

    @Override
    protected MixMessage decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        byte b = frame.readByte();
        MixMessage.MixEventName event = MixMessage.MixEventName.resolve(b);
        Object feature = MixMessageDecoder.decodeObject(frame);
        float weight = frame.readFloat();
        float covariance = frame.readFloat();
        short clock = frame.readShort();
        int deltaUpdates = frame.readInt();
        boolean cancelRequest = frame.readBoolean();
        String groupID = MixMessageDecoder.readString(frame);
        MixMessage msg = new MixMessage(event, feature, weight, covariance, clock, deltaUpdates, cancelRequest);
        msg.setGroupID(groupID);
        return msg;
    }

    private static Object decodeObject(ByteBuf in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                int i = in.readInt();
                return i;
            }
            case 2: {
                int length = in.readInt();
                byte[] b = new byte[length];
                in.readBytes(b, 0, length);
                Text t = new Text(b);
                return t;
            }
            case 3: {
                return MixMessageDecoder.readString(in);
            }
            case 4: {
                int i = in.readInt();
                return new IntWritable(i);
            }
            case 5: {
                long l = in.readLong();
                return new LongWritable(l);
            }
        }
        throw new IllegalStateException("Illegal type: " + type);
    }

    private static String readString(ByteBuf in) {
        int length = in.readInt();
        if (length == -1) {
            return null;
        }
        byte[] b = new byte[length];
        in.readBytes(b, 0, length);
        String s = StringUtils.toString(b);
        return s;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

