/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mf;

import hivemall.mf.Rating;
import hivemall.mf.RatingInitilizer;
import hivemall.utils.collections.IntOpenHashMap;
import hivemall.utils.math.MathUtils;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FactorizedModel {
    @Nonnull
    private final RatingInitilizer ratingInitializer;
    @Nonnegative
    private final int factor;
    private final RankInitScheme initScheme;
    private int minIndex;
    private int maxIndex;
    @Nonnull
    private Rating meanRating;
    private IntOpenHashMap<Rating[]> users;
    private IntOpenHashMap<Rating[]> items;
    private IntOpenHashMap<Rating> userBias;
    private IntOpenHashMap<Rating> itemBias;
    private final Random[] randU;
    private final Random[] randI;

    public FactorizedModel(@Nonnull RatingInitilizer ratingInitializer, @Nonnegative int factor, @Nonnull RankInitScheme initScheme) {
        this(ratingInitializer, factor, 0.0f, initScheme, 136861);
    }

    public FactorizedModel(@Nonnull RatingInitilizer ratingInitializer, @Nonnegative int factor, float meanRating, @Nonnull RankInitScheme initScheme) {
        this(ratingInitializer, factor, meanRating, initScheme, 136861);
    }

    public FactorizedModel(@Nonnull RatingInitilizer ratingInitializer, @Nonnegative int factor, float meanRating, @Nonnull RankInitScheme initScheme, int expectedSize) {
        this.ratingInitializer = ratingInitializer;
        this.factor = factor;
        this.initScheme = initScheme;
        this.minIndex = 0;
        this.maxIndex = 0;
        this.meanRating = ratingInitializer.newRating(meanRating);
        this.users = new IntOpenHashMap(expectedSize);
        this.items = new IntOpenHashMap(expectedSize);
        this.userBias = new IntOpenHashMap(expectedSize);
        this.itemBias = new IntOpenHashMap(expectedSize);
        this.randU = FactorizedModel.newRandoms(factor, 31L);
        this.randI = FactorizedModel.newRandoms(factor, 41L);
    }

    private static Random[] newRandoms(@Nonnull int size, long seed) {
        Random[] rand = new Random[size];
        int len = rand.length;
        for (int i = 0; i < len; ++i) {
            rand[i] = new Random(seed + (long)i);
        }
        return rand;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    @Nonnull
    public Rating meanRating() {
        return this.meanRating;
    }

    public float getMeanRating() {
        return this.meanRating.getWeight();
    }

    public void setMeanRating(float rating) {
        this.meanRating.setWeight(rating);
    }

    @Nullable
    public Rating[] getUserVector(int u) {
        return this.getUserVector(u, false);
    }

    @Nullable
    public Rating[] getUserVector(int u, boolean init) {
        Rating[] v = this.users.get(u);
        if (init && v == null) {
            v = new Rating[this.factor];
            switch (this.initScheme) {
                case random: {
                    FactorizedModel.uniformFill(v, this.randU[0], this.initScheme.maxInitValue, this.ratingInitializer);
                    break;
                }
                case gaussian: {
                    FactorizedModel.gaussianFill(v, this.randU, this.initScheme.initStdDev, this.ratingInitializer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported rank initialization scheme: " + (Object)((Object)this.initScheme));
                }
            }
            this.users.put(u, v);
            this.maxIndex = Math.max(this.maxIndex, u);
            this.minIndex = Math.min(this.minIndex, u);
        }
        return v;
    }

    @Nullable
    public Rating[] getItemVector(int i) {
        return this.getItemVector(i, false);
    }

    @Nullable
    public Rating[] getItemVector(int i, boolean init) {
        Rating[] v = this.items.get(i);
        if (init && v == null) {
            v = new Rating[this.factor];
            switch (this.initScheme) {
                case random: {
                    FactorizedModel.uniformFill(v, this.randI[0], this.initScheme.maxInitValue, this.ratingInitializer);
                    break;
                }
                case gaussian: {
                    FactorizedModel.gaussianFill(v, this.randI, this.initScheme.initStdDev, this.ratingInitializer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported rank initialization scheme: " + (Object)((Object)this.initScheme));
                }
            }
            this.items.put(i, v);
            this.maxIndex = Math.max(this.maxIndex, i);
            this.minIndex = Math.min(this.minIndex, i);
        }
        return v;
    }

    @Nonnull
    public Rating userBias(int u) {
        Rating b = this.userBias.get(u);
        if (b == null) {
            b = this.ratingInitializer.newRating(0.0f);
            this.userBias.put(u, b);
        }
        return b;
    }

    public float getUserBias(int u) {
        Rating b = this.userBias.get(u);
        if (b == null) {
            return 0.0f;
        }
        return b.getWeight();
    }

    public void setUserBias(int u, float value) {
        Rating b = this.userBias.get(u);
        if (b == null) {
            b = this.ratingInitializer.newRating(value);
            this.userBias.put(u, b);
        }
        b.setWeight(value);
    }

    @Nonnull
    public Rating itemBias(int i) {
        Rating b = this.itemBias.get(i);
        if (b == null) {
            b = this.ratingInitializer.newRating(0.0f);
            this.itemBias.put(i, b);
        }
        return b;
    }

    @Nullable
    public Rating getItemBiasObject(int i) {
        return this.itemBias.get(i);
    }

    public float getItemBias(int i) {
        Rating b = this.itemBias.get(i);
        if (b == null) {
            return 0.0f;
        }
        return b.getWeight();
    }

    public void setItemBias(int i, float value) {
        Rating b = this.itemBias.get(i);
        if (b == null) {
            b = this.ratingInitializer.newRating(value);
            this.itemBias.put(i, b);
        }
        b.setWeight(value);
    }

    private static void uniformFill(Rating[] a, Random rand, float maxInitValue, RatingInitilizer init) {
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            float v = rand.nextFloat() * maxInitValue / (float)len;
            a[i] = init.newRating(v);
        }
    }

    private static void gaussianFill(Rating[] a, Random[] rand, double stddev, RatingInitilizer init) {
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            float v = (float)MathUtils.gaussian(0.0, stddev, rand[i]);
            a[i] = init.newRating(v);
        }
    }

    public static enum RankInitScheme {
        random,
        gaussian;

        @Nonnegative
        private float maxInitValue;
        @Nonnegative
        private double initStdDev;

        @Nonnull
        public static RankInitScheme resolve(@Nullable String opt) {
            if (opt == null) {
                return random;
            }
            if ("gaussian".equalsIgnoreCase(opt)) {
                return gaussian;
            }
            if ("random".equalsIgnoreCase(opt)) {
                return random;
            }
            return random;
        }

        public void setMaxInitValue(float maxInitValue) {
            this.maxInitValue = maxInitValue;
        }

        public void setInitStdDev(double initStdDev) {
            this.initStdDev = initStdDev;
        }
    }
}

