/*
 * Decompiled with CFR 0.152.
 */
package hivemall.mf;

import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.FloatWritable;

@Description(name="bprmf_predict", value="_FUNC_(List<Float> Pu, List<Float> Qi[, double Bi]) - Returns the prediction value")
@UDFType(deterministic=true, stateful=false)
public final class BPRMFPredictionUDF
extends UDF {
    public FloatWritable evaluate(List<Float> Pu, List<Float> Qi) throws HiveException {
        return this.evaluate(Pu, Qi, 0.0);
    }

    public FloatWritable evaluate(List<Float> Pu, List<Float> Qi, double Bi) throws HiveException {
        if (Pu == null && Qi == null) {
            return new FloatWritable(0.0f);
        }
        if (Pu == null) {
            return new FloatWritable((float)Bi);
        }
        if (Qi == null) {
            return new FloatWritable(0.0f);
        }
        int PuSize = Pu.size();
        int QiSize = Qi.size();
        if (PuSize == 0) {
            if (QiSize == 0) {
                return new FloatWritable(0.0f);
            }
            return new FloatWritable((float)Bi);
        }
        if (QiSize == 0) {
            return new FloatWritable(0.0f);
        }
        if (QiSize != PuSize) {
            throw new HiveException("|Pu| " + PuSize + " was not equal to |Qi| " + QiSize);
        }
        float ret = (float)Bi;
        for (int k = 0; k < PuSize; ++k) {
            ret += Pu.get(k).floatValue() * Qi.get(k).floatValue();
        }
        return new FloatWritable(ret);
    }
}

