/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.similarity;

import hivemall.knn.distance.HammingDistanceUDF;
import hivemall.utils.hadoop.WritableUtils;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.FloatWritable;

@Description(name="jaccard_similarity", value="_FUNC_(A, B [,int k]) - Returns Jaccard similarity coefficient of A and B")
@UDFType(deterministic=true, stateful=false)
public final class JaccardIndexUDF
extends UDF {
    private final Set<Object> union = new HashSet<Object>();
    private final Set<Object> intersect = new HashSet<Object>();

    public FloatWritable evaluate(long a, long b) {
        return this.evaluate(a, b, 128);
    }

    public FloatWritable evaluate(long a, long b, int k) {
        int countMatches = k - HammingDistanceUDF.hammingDistance(a, b);
        float jaccard = (float)countMatches / (float)k;
        return WritableUtils.val(2.0f * (jaccard - 0.5f));
    }

    public FloatWritable evaluate(String a, String b) {
        return this.evaluate(a, b, 128);
    }

    public FloatWritable evaluate(String a, String b, int k) {
        BigInteger ai = new BigInteger(a);
        BigInteger bi = new BigInteger(b);
        int countMatches = k - HammingDistanceUDF.hammingDistance(ai, bi);
        float jaccard = (float)countMatches / (float)k;
        return WritableUtils.val(2.0f * (jaccard - 0.5f));
    }

    public FloatWritable evaluate(List<String> a, List<String> b) {
        if (a == null && b == null) {
            return new FloatWritable(1.0f);
        }
        if (a == null || b == null) {
            return new FloatWritable(0.0f);
        }
        int asize = a.size();
        int bsize = b.size();
        if (asize == 0 && bsize == 0) {
            return new FloatWritable(1.0f);
        }
        if (asize == 0 || bsize == 0) {
            return new FloatWritable(0.0f);
        }
        this.union.addAll(a);
        this.union.addAll(b);
        float unionSize = this.union.size();
        this.union.clear();
        this.intersect.addAll(a);
        this.intersect.retainAll(b);
        float intersectSize = this.intersect.size();
        this.intersect.clear();
        return new FloatWritable(intersectSize / unionSize);
    }
}

