/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.similarity;

import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.FloatWritable;

@Description(name="distance2similarity", value="_FUNC_(float d) - Returns 1.0 / (1.0 + d)")
@UDFType(deterministic=true, stateful=false)
public final class Distance2SimilarityUDF
extends GenericUDF {
    private PrimitiveObjectInspector distanceOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("distance2similarity takes 1 argument");
        }
        this.distanceOI = HiveUtils.asDoubleCompatibleOI(argOIs[0]);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    public FloatWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        float d = PrimitiveObjectInspectorUtils.getFloat((Object)arguments[0], (PrimitiveObjectInspector)this.distanceOI);
        float sim = 1.0f / (1.0f + d);
        return new FloatWritable(sim);
    }

    public String getDisplayString(String[] children) {
        return "distance2similarity(" + Arrays.toString(children) + ")";
    }
}

