/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.similarity;

import hivemall.knn.similarity.CosineSimilarityUDF;
import hivemall.utils.hadoop.HiveUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.FloatWritable;

@Description(name="angular_similarity", value="_FUNC_(ftvec1, ftvec2) - Returns an angular similarity of the given two vectors")
@UDFType(deterministic=true, stateful=false)
public final class AngularSimilarityUDF
extends GenericUDF {
    private ListObjectInspector arg0ListOI;
    private ListObjectInspector arg1ListOI;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("angular_similarity takes 2 arguments");
        }
        this.arg0ListOI = HiveUtils.asListOI(argOIs[0]);
        this.arg1ListOI = HiveUtils.asListOI(argOIs[1]);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    public FloatWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        List<String> ftvec1 = HiveUtils.asStringList(arguments[0], this.arg0ListOI);
        List<String> ftvec2 = HiveUtils.asStringList(arguments[1], this.arg1ListOI);
        float similarity = AngularSimilarityUDF.angularSimilarity(ftvec1, ftvec2);
        return new FloatWritable(similarity);
    }

    public static float angularSimilarity(List<String> ftvec1, List<String> ftvec2) {
        float cosineSim = CosineSimilarityUDF.cosineSimilarity(ftvec1, ftvec2);
        return 1.0f - (float)(Math.acos(cosineSim) / Math.PI);
    }

    public String getDisplayString(String[] children) {
        return "angular_similarity(" + Arrays.toString(children) + ")";
    }
}

