/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.lsh;

import hivemall.model.FeatureValue;
import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.hashing.MurmurHash3;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="bbit_minhash", value="_FUNC_(array<> features [, int numHashes]) - Returns a b-bits minhash value")
@UDFType(deterministic=true, stateful=false)
public final class bBitMinHashUDF
extends UDF {
    private int[] _seeds = null;

    private int[] prepareSeeds(int numHashes) {
        int[] seeds = this._seeds;
        if (seeds == null || seeds.length != numHashes) {
            seeds = new int[numHashes];
            Random rand = new Random(31L);
            for (int i = 0; i < numHashes; ++i) {
                seeds[i] = rand.nextInt();
            }
            this._seeds = seeds;
        }
        return seeds;
    }

    public Text evaluate(List<Integer> features) throws HiveException {
        return this.evaluate(features, 128);
    }

    public Text evaluate(List<Integer> features, int numHashes) throws HiveException {
        int[] seeds = this.prepareSeeds(numHashes);
        List<FeatureValue> featureList = bBitMinHashUDF.parseFeatures(features);
        return WritableUtils.val(bBitMinHashUDF.computeSignatures(featureList, numHashes, seeds));
    }

    public Text evaluate(List<String> features, boolean noWeight) throws HiveException {
        return this.evaluate(features, 128, noWeight);
    }

    public Text evaluate(List<String> features, int numHashes, boolean noWeight) throws HiveException {
        int[] seeds = this.prepareSeeds(numHashes);
        List<FeatureValue> featureList = bBitMinHashUDF.parseFeatures(features, noWeight);
        return WritableUtils.val(bBitMinHashUDF.computeSignatures(featureList, numHashes, seeds));
    }

    private static List<FeatureValue> parseFeatures(List<Integer> features) {
        ArrayList<FeatureValue> ftvec = new ArrayList<FeatureValue>(features.size());
        for (Integer f : features) {
            if (f == null) continue;
            FeatureValue fv = new FeatureValue((Object)f, 1.0f);
            ftvec.add(fv);
        }
        return ftvec;
    }

    private static List<FeatureValue> parseFeatures(List<String> features, boolean noWeight) {
        ArrayList<FeatureValue> ftvec = new ArrayList<FeatureValue>(features.size());
        for (String f : features) {
            if (f == null) continue;
            FeatureValue fv = noWeight ? new FeatureValue((Object)f, 1.0f) : FeatureValue.parse(f);
            ftvec.add(fv);
        }
        return ftvec;
    }

    private static String computeSignatures(List<FeatureValue> features, int numHashes, int[] seeds) throws HiveException {
        if (numHashes <= 0 || numHashes > 512) {
            throw new HiveException("The number of hash function must be in range (0,512]: " + numHashes);
        }
        int[] hashes = new int[numHashes];
        for (int i = 0; i < numHashes; ++i) {
            float weightedMinHashValues = Float.MAX_VALUE;
            for (FeatureValue fv : features) {
                float w;
                Object f = fv.getFeature();
                assert (f != null);
                String fs = f.toString();
                int hashIndex = Math.abs(MurmurHash3.murmurhash3_x86_32(fs, seeds[i]));
                float hashValue = bBitMinHashUDF.calcWeightedHashValue(hashIndex, w = fv.getValueAsFloat());
                if (!(hashValue < weightedMinHashValues)) continue;
                weightedMinHashValues = hashValue;
                hashes[i] = hashIndex;
            }
        }
        BigInteger value = BigInteger.valueOf(0L);
        for (int i = 0; i < numHashes; ++i) {
            if ((hashes[i] & 1) != 1) continue;
            value = value.setBit(i);
        }
        return value.toString();
    }

    private static float calcWeightedHashValue(int hashIndex, float w) throws HiveException {
        if (w < 0.0f) {
            throw new HiveException("Non-negative value is not accepted for a feature weight");
        }
        if (w == 0.0f) {
            return Float.MAX_VALUE;
        }
        return (float)hashIndex / w;
    }
}

