/*
 * Decompiled with CFR 0.152.
 */
package hivemall.knn.distance;

import hivemall.utils.hadoop.WritableUtils;
import java.math.BigInteger;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="popcnt", value="_FUNC_(a [, b]) - Returns a popcount value")
@UDFType(deterministic=true, stateful=false)
public final class PopcountUDF
extends UDF {
    public IntWritable evaluate(long a) {
        return WritableUtils.val(Long.bitCount(a));
    }

    public IntWritable evaluate(String a) {
        BigInteger ai = new BigInteger(a);
        return WritableUtils.val(ai.bitCount());
    }

    public IntWritable evaluate(List<Long> a) {
        int result = 0;
        for (int i = 0; i < a.size(); ++i) {
            long x = a.get(i);
            result += Long.bitCount(x);
        }
        return WritableUtils.val(result);
    }

    public IntWritable evaluate(long a, long b) {
        long innerProduct = a & b;
        return WritableUtils.val(Long.bitCount(innerProduct));
    }

    public IntWritable evaluate(String a, String b) {
        BigInteger ai = new BigInteger(a);
        BigInteger bi = new BigInteger(b);
        BigInteger innerProduct = ai.and(bi);
        return WritableUtils.val(innerProduct.bitCount());
    }

    public IntWritable evaluate(List<Long> a, List<Long> b) {
        int min = Math.min(a.size(), b.size());
        int result = 0;
        for (int i = 0; i < min; ++i) {
            long innerProduct = a.get(i) & b.get(i);
            result += Long.bitCount(innerProduct);
        }
        return WritableUtils.val(result);
    }
}

