/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.trans;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Text;

@Description(name="vectorize_features", value="_FUNC_(array<string> featureNames, ...) - Returns a feature vector array<string>")
@UDFType(deterministic=true, stateful=false)
public final class VectorizeFeaturesUDF
extends GenericUDF {
    private String[] featureNames;
    private PrimitiveObjectInspector[] inputOIs;
    private List<Text> result;

    public ObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        int numArgOIs = argOIs.length;
        if (numArgOIs < 2) {
            throw new UDFArgumentException("argOIs.length must be greater that or equals to 2: " + numArgOIs);
        }
        this.featureNames = HiveUtils.getConstStringArray(argOIs[0]);
        if (this.featureNames == null) {
            throw new UDFArgumentException("#featureNames should not be null");
        }
        int numFeatureNames = this.featureNames.length;
        if (numFeatureNames < 1) {
            throw new UDFArgumentException("#featureNames must be greater than or equals to 1: " + numFeatureNames);
        }
        int numFeatures = numArgOIs - 1;
        if (numFeatureNames != numFeatures) {
            throw new UDFArgumentException("#featureNames '" + numFeatureNames + "' != #arguments '" + numFeatures + "'");
        }
        this.inputOIs = new PrimitiveObjectInspector[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            ObjectInspector oi = argOIs[i + 1];
            this.inputOIs[i] = HiveUtils.asPrimitiveObjectInspector(oi);
        }
        this.result = new ArrayList<Text>(numFeatures);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    public List<Text> evaluate(@Nonnull GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.clear();
        int size = arguments.length - 1;
        for (int i = 0; i < size; ++i) {
            float v;
            Text f;
            String featureName;
            Object argument = arguments[i + 1].get();
            if (argument == null) continue;
            PrimitiveObjectInspector oi = this.inputOIs[i];
            if (oi.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                String s = PrimitiveObjectInspectorUtils.getString((Object)argument, (PrimitiveObjectInspector)oi);
                if (s.isEmpty()) continue;
                if (!StringUtils.isNumber(s)) {
                    featureName = this.featureNames[i];
                    f = new Text(featureName + '#' + s);
                    this.result.add(f);
                    continue;
                }
            }
            if ((v = PrimitiveObjectInspectorUtils.getFloat((Object)argument, (PrimitiveObjectInspector)oi)) == 0.0f) continue;
            featureName = this.featureNames[i];
            f = new Text(featureName + ':' + v);
            this.result.add(f);
        }
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return "vectorize_features(" + Arrays.toString(children) + ")";
    }
}

