/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.trans;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.lang.Identifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="quantified_features", value="_FUNC_(boolean output, col1, col2, ...) - Returns an identified features in a dence array<double>")
public final class QuantifiedFeaturesUDTF
extends GenericUDTF {
    private BooleanObjectInspector boolOI;
    private PrimitiveObjectInspector[] doubleOIs;
    private Identifier<String>[] identifiers;
    private DoubleWritable[] columnValues;
    private transient Object[] fowardObjs;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        int size = argOIs.length;
        if (size < 2) {
            throw new UDFArgumentException("quantified_features takes at least two arguments: " + size);
        }
        this.boolOI = HiveUtils.asBooleanOI(argOIs[0]);
        int outputSize = size - 1;
        this.doubleOIs = new PrimitiveObjectInspector[outputSize];
        this.columnValues = new DoubleWritable[outputSize];
        this.identifiers = new Identifier[outputSize];
        this.fowardObjs = null;
        for (int i = 0; i < outputSize; ++i) {
            this.columnValues[i] = new DoubleWritable(Double.NaN);
            ObjectInspector argOI = argOIs[i + 1];
            if (HiveUtils.isNumberOI(argOI)) {
                this.doubleOIs[i] = HiveUtils.asDoubleCompatibleOI(argOI);
                continue;
            }
            this.identifiers[i] = new Identifier();
        }
        ArrayList<String> fieldNames = new ArrayList<String>(outputSize);
        ArrayList<StandardListObjectInspector> fieldOIs = new ArrayList<StandardListObjectInspector>(outputSize);
        fieldNames.add("features");
        fieldOIs.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        boolean outputRow;
        if (this.fowardObjs == null) {
            this.fowardObjs = new Object[]{Arrays.asList(this.columnValues)};
        }
        if (outputRow = this.boolOI.get(args[0])) {
            DoubleWritable[] values = this.columnValues;
            int outputSize = args.length - 1;
            for (int i = 0; i < outputSize; ++i) {
                Object arg = args[i + 1];
                Identifier<String> identifier = this.identifiers[i];
                if (identifier == null) {
                    double v = PrimitiveObjectInspectorUtils.getDouble((Object)arg, (PrimitiveObjectInspector)this.doubleOIs[i]);
                    values[i].set(v);
                    continue;
                }
                if (arg == null) {
                    throw new HiveException("Found Null in the input: " + Arrays.toString(args));
                }
                String k = arg.toString();
                int id = identifier.valueOf(k);
                values[i].set((double)id);
            }
            this.forward(this.fowardObjs);
        } else {
            int outputSize = args.length - 1;
            for (int i = 0; i < outputSize; ++i) {
                Object arg;
                Identifier<String> identifier = this.identifiers[i];
                if (identifier == null || (arg = args[i + 1]) == null) continue;
                String k = arg.toString();
                identifier.valueOf(k);
            }
        }
    }

    public void close() throws HiveException {
        this.boolOI = null;
        this.doubleOIs = null;
        this.identifiers = null;
        this.columnValues = null;
        this.fowardObjs = null;
    }
}

