/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.text;

import hivemall.utils.lang.mutable.MutableInt;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;

@Description(name="tf", value="_FUNC_(string text) - Return a term frequency in <string, float>")
public final class TermFrequencyUDAF
extends UDAF {

    public static class Evaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(Text term) {
            if (term == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
                this.partial.map.put(new Text(term), new MutableInt(1));
            } else {
                Map map = this.partial.map;
                MutableInt count = (MutableInt)map.get(term);
                if (count == null) {
                    map.put(new Text(term), new MutableInt(1));
                } else {
                    int newcount = count.getValue() + 1;
                    count.setValue(newcount);
                }
            }
            this.partial.globalCount++;
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult other) {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            Map this_map = this.partial.map;
            Map other_map = other.map;
            for (Map.Entry e : other_map.entrySet()) {
                Text term = (Text)e.getKey();
                MutableInt other_count = (MutableInt)e.getValue();
                MutableInt this_count = (MutableInt)this_map.get(term);
                if (this_count == null) {
                    this_map.put(term, other_count);
                    continue;
                }
                int newcount = this_count.getValue() + other_count.getValue();
                this_count.setValue(newcount);
            }
            PartialResult partialResult = this.partial;
            partialResult.globalCount = partialResult.globalCount + other.globalCount;
            return true;
        }

        public Map<Text, FloatWritable> terminate() {
            if (this.partial == null) {
                return null;
            }
            long globalCount = this.partial.globalCount;
            HashMap<Text, FloatWritable> tfmap = new HashMap<Text, FloatWritable>();
            for (Map.Entry e : this.partial.map.entrySet()) {
                Text term = (Text)e.getKey();
                float other_count = ((MutableInt)e.getValue()).getValue();
                float freq = other_count / (float)globalCount;
                tfmap.put(term, new FloatWritable(freq));
            }
            this.partial = null;
            return tfmap;
        }

        public static class PartialResult {
            private final Map<Text, MutableInt> map = new HashMap<Text, MutableInt>();
            private long globalCount = 0L;
        }
    }
}

