/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.scaling;

import hivemall.utils.hadoop.WritableUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;

@Description(name="rescale", value="_FUNC_(value, min, max) - Returns rescaled value by min-max normalization")
@UDFType(deterministic=true, stateful=false)
public final class RescaleUDF
extends UDF {
    public FloatWritable evaluate(float value, float min, float max) {
        return WritableUtils.val(RescaleUDF.min_max_normalization(value, min, max));
    }

    public FloatWritable evaluate(double value, double min, double max) {
        return WritableUtils.val(RescaleUDF.min_max_normalization(value, min, max));
    }

    public Text evaluate(String s, double min, double max) {
        String[] fv = s.split(":");
        if (fv.length != 2) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        double v = Float.parseFloat(fv[1]);
        float scaled_v = RescaleUDF.min_max_normalization(v, min, max);
        String ret = fv[0] + ':' + Float.toString(scaled_v);
        return WritableUtils.val(ret);
    }

    public Text evaluate(String s, float min, float max) {
        String[] fv = s.split(":");
        if (fv.length != 2) {
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        float v = Float.parseFloat(fv[1]);
        float scaled_v = RescaleUDF.min_max_normalization(v, min, max);
        String ret = fv[0] + ':' + Float.toString(scaled_v);
        return WritableUtils.val(ret);
    }

    private static float min_max_normalization(float value, float min, float max) {
        if (min == max) {
            return 0.5f;
        }
        return (value - min) / (max - min);
    }

    private static float min_max_normalization(double value, double min, double max) {
        if (min == max) {
            return 0.5f;
        }
        return (float)((value - min) / (max - min));
    }
}

