/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.scaling;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.Text;

@Description(name="l2_normalize", value="_FUNC_(ftvec string) - Returned a L2 normalized value")
@UDFType(deterministic=true, stateful=false)
public final class L2NormalizationUDF
extends UDF {
    public List<Text> evaluate(List<Text> ftvecs) {
        String f;
        if (ftvecs == null) {
            return null;
        }
        double squaredSum = 0.0;
        int numFeatures = ftvecs.size();
        String[] features = new String[numFeatures];
        float[] weights = new float[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            Text ftvec = ftvecs.get(i);
            if (ftvec == null) continue;
            String s = ftvec.toString();
            String[] ft = s.split(":");
            int ftlen = ft.length;
            if (ftlen == 1) {
                features[i] = ft[0];
                weights[i] = 1.0f;
                squaredSum += 1.0;
                continue;
            }
            if (ftlen == 2) {
                float v;
                features[i] = ft[0];
                weights[i] = v = Float.parseFloat(ft[1]);
                squaredSum += (double)(v * v);
                continue;
            }
            throw new IllegalArgumentException("Invalid feature value representation: " + s);
        }
        float norm = (float)Math.sqrt(squaredSum);
        Text[] t = new Text[numFeatures];
        if (norm == 0.0f) {
            for (int i = 0; i < numFeatures; ++i) {
                f = features[i];
                t[i] = new Text(f + ':' + 0.0f);
            }
        } else {
            for (int i = 0; i < numFeatures; ++i) {
                f = features[i];
                float v = weights[i] / norm;
                t[i] = new Text(f + ':' + v);
            }
        }
        return Arrays.asList(t);
    }
}

