/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.ranking;

import hivemall.ftvec.ranking.PositiveOnlyFeedback;
import hivemall.utils.collections.IntArrayList;
import hivemall.utils.lang.ArrayUtils;
import java.util.Random;
import javax.annotation.Nonnull;

public final class PerEventPositiveOnlyFeedback
extends PositiveOnlyFeedback {
    @Nonnull
    private final IntArrayList users = new IntArrayList(1024);
    @Nonnull
    private final IntArrayList posItems = new IntArrayList(1024);

    public PerEventPositiveOnlyFeedback(int maxItemId) {
        super(maxItemId);
        this.totalFeedbacks = 0;
    }

    @Nonnull
    public int[] getRandomIndex(@Nonnull Random rand) {
        int[] index = new int[this.totalFeedbacks];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        ArrayUtils.shuffle(index, rand);
        return index;
    }

    public int getUser(int index) {
        return this.users.fastGet(index);
    }

    public int getPositiveItem(int index) {
        return this.posItems.fastGet(index);
    }

    @Override
    public void addFeedback(int userId, @Nonnull IntArrayList itemIds) {
        super.addFeedback(userId, itemIds);
        int size = itemIds.size();
        for (int i = 0; i < size; ++i) {
            int posItem = itemIds.fastGet(i);
            this.users.add(userId);
            this.posItems.add(posItem);
        }
    }

    @Override
    public void removeFeedback(int userId) {
        throw new UnsupportedOperationException();
    }
}

