/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.hashing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="sha1", value="_FUNC_(string word [, int numFeatures]) returns a SHA-1 value")
@UDFType(deterministic=true, stateful=false)
public final class Sha1UDF
extends UDF {
    public static final int DEFAULT_NUM_FEATURES = 0x1000000;
    private final MessageDigest sha256;

    public Sha1UDF() {
        try {
            this.sha256 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public IntWritable evaluate(String word) {
        return this.evaluate(word, 0x1000000);
    }

    public IntWritable evaluate(String word, boolean rawValue) {
        if (rawValue) {
            int sha1 = this.sha1(word);
            return new IntWritable(sha1);
        }
        return this.evaluate(word, 0x1000000);
    }

    public IntWritable evaluate(String word, int numFeatures) {
        int r = this.sha1(word) % numFeatures;
        if (r < 0) {
            r += numFeatures;
        }
        return new IntWritable(r + 1);
    }

    public IntWritable evaluate(List<String> words) {
        return this.evaluate(words, 0x1000000);
    }

    public IntWritable evaluate(List<String> words, int numFeatures) {
        int wlength = words.size();
        if (wlength == 0) {
            return new IntWritable(1);
        }
        StringBuilder b = new StringBuilder();
        b.append(words.get(0));
        for (int i = 1; i < wlength; ++i) {
            b.append('\t');
            b.append(words.get(i));
        }
        String s = b.toString();
        return this.evaluate(s, numFeatures);
    }

    private int sha1(String word) {
        MessageDigest md;
        try {
            md = (MessageDigest)this.sha256.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        byte[] in = Sha1UDF.getBytes(word);
        byte[] di = md.digest(in);
        return Sha1UDF.getInt(di, 0);
    }

    private static byte[] getBytes(String s) {
        int len = s.length();
        byte[] b = new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            Sha1UDF.putChar(b, i << 1, s.charAt(i));
        }
        return b;
    }

    private static void putChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off] = (byte)(val >>> 8);
    }

    private static int getInt(byte[] b, int off) {
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }
}

