/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.hashing;

import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.hashing.MurmurHash3;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;

@Description(name="array_hash_values", value="_FUNC_(array<string> values, [string prefix [, int numFeatures], boolean useIndexAsPrefix]) returns hash values in array<int>")
@UDFType(deterministic=true, stateful=false)
public final class ArrayHashValuesUDF
extends UDF {
    public List<IntWritable> evaluate(List<String> values) {
        return this.evaluate(values, null, 0x1000000);
    }

    public List<IntWritable> evaluate(List<String> values, String prefix) {
        return this.evaluate(values, prefix, 0x1000000);
    }

    public List<IntWritable> evaluate(List<String> values, String prefix, boolean useIndexAsPrefix) {
        return this.evaluate(values, prefix, 0x1000000, useIndexAsPrefix);
    }

    public List<IntWritable> evaluate(List<String> values, String prefix, int numFeatures) {
        return this.evaluate(values, prefix, numFeatures, false);
    }

    public List<IntWritable> evaluate(List<String> values, String prefix, int numFeatures, boolean useIndexAsPrefix) {
        return ArrayHashValuesUDF.hashValues(values, prefix, numFeatures, useIndexAsPrefix);
    }

    static List<IntWritable> hashValues(List<String> values, String prefix, int numFeatures, boolean useIndexAsPrefix) {
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        int size = values.size();
        IntWritable[] ary = new IntWritable[size];
        for (int i = 0; i < size; ++i) {
            String v = values.get(i);
            if (v == null) {
                ary[i] = null;
                continue;
            }
            if (useIndexAsPrefix) {
                v = i + 58 + v;
            }
            String data = prefix == null ? v : prefix + v;
            int h = MurmurHash3.murmurhash3(data, numFeatures);
            ary[i] = WritableUtils.val(h + 1);
        }
        return Arrays.asList(ary);
    }
}

