/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec.amplify;

import hivemall.utils.hadoop.HiveUtils;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="amplify", value="_FUNC_(const int xtimes, *) - amplify the input records x-times")
public final class AmplifierUDTF
extends GenericUDTF {
    private int xtimes;
    private Object[] forwardObjs;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length < 2) {
            throw new UDFArgumentException("_FUNC_(int xtimes, *) takes at least two arguments");
        }
        this.xtimes = HiveUtils.getAsConstInt(argOIs[0]);
        if (this.xtimes < 1) {
            throw new UDFArgumentException("Illegal xtimes value: " + this.xtimes);
        }
        this.forwardObjs = new Object[argOIs.length - 1];
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (int i = 1; i < argOIs.length; ++i) {
            fieldNames.add("c" + i);
            fieldOIs.add(argOIs[i]);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        Object[] forwardObjs = this.forwardObjs;
        for (int i = 1; i < args.length; ++i) {
            forwardObjs[i - 1] = args[i];
        }
        for (int x = 0; x < this.xtimes; ++x) {
            this.forward(forwardObjs);
        }
    }

    public void close() throws HiveException {
        this.forwardObjs = null;
    }
}

