/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="extract_weight", value="_FUNC_(feature_vector in array<string>) - Returns the weights of features in array<string>")
@UDFType(deterministic=true, stateful=false)
public final class ExtractWeightUDF
extends UDF {
    public DoubleWritable evaluate(String featureVector) throws UDFArgumentException {
        return ExtractWeightUDF.extractWeights(featureVector);
    }

    public List<DoubleWritable> evaluate(List<String> featureVectors) throws UDFArgumentException {
        if (featureVectors == null) {
            return null;
        }
        int size = featureVectors.size();
        DoubleWritable[] output = new DoubleWritable[size];
        for (int i = 0; i < size; ++i) {
            String ftvec = featureVectors.get(i);
            output[i] = ExtractWeightUDF.extractWeights(ftvec);
        }
        return Arrays.asList(output);
    }

    static DoubleWritable extractWeights(String ftvec) throws UDFArgumentException {
        if (ftvec == null) {
            return null;
        }
        int pos = ftvec.lastIndexOf(58);
        if (pos > 0) {
            String s = ftvec.substring(pos + 1);
            double d = ExtractWeightUDF.parseDouble(s);
            return new DoubleWritable(d);
        }
        return new DoubleWritable(1.0);
    }

    private static double parseDouble(@Nonnull String v) throws UDFArgumentException {
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException nfe) {
            throw new UDFArgumentException((Throwable)nfe);
        }
    }
}

