/*
 * Decompiled with CFR 0.152.
 */
package hivemall.ftvec;

import hivemall.utils.hadoop.WritableUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="add_bias", value="_FUNC_(feature_vector in array<string>) - Returns features with a bias in array<string>")
@UDFType(deterministic=true, stateful=false)
public final class AddBiasUDF
extends UDF {
    public List<Text> evaluate(List<String> ftvec) {
        return this.evaluate(ftvec, "0");
    }

    public List<Text> evaluate(List<String> ftvec, String biasClause) {
        float biasValue = 1.0f;
        return this.evaluate(ftvec, biasClause, biasValue);
    }

    public List<Text> evaluate(List<String> ftvec, String biasClause, float biasValue) {
        int size = ftvec.size();
        String[] newvec = new String[size + 1];
        ftvec.toArray(newvec);
        newvec[size] = biasClause + ":" + Float.toString(biasValue);
        return WritableUtils.val(newvec);
    }

    public List<IntWritable> evaluate(List<IntWritable> ftvec, IntWritable biasClause) {
        int size = ftvec.size();
        IntWritable[] newvec = new IntWritable[size + 1];
        ftvec.toArray(newvec);
        newvec[size] = biasClause;
        return Arrays.asList(newvec);
    }
}

