/*
 * Decompiled with CFR 0.152.
 */
package hivemall.fm;

import hivemall.fm.IntFeature;
import hivemall.fm.StringFeature;
import hivemall.utils.hashing.MurmurHash3;
import hivemall.utils.lang.NumberUtils;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;

public abstract class Feature {
    public static final int DEFAULT_NUM_FIELDS = 1024;
    public static final int DEFAULT_FEATURE_BITS = 21;
    public static final int DEFAULT_NUM_FEATURES = 0x200000;
    protected double value;

    public Feature() {
    }

    public Feature(double value) {
        this.value = value;
    }

    public void setFeature(@Nonnull String f) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public String getFeature() {
        throw new UnsupportedOperationException();
    }

    public void setFeatureIndex(int i) {
        throw new UnsupportedOperationException();
    }

    public int getFeatureIndex() {
        throw new UnsupportedOperationException();
    }

    public short getField() {
        throw new UnsupportedOperationException();
    }

    public void setField(short field) {
        throw new UnsupportedOperationException();
    }

    public double getValue() {
        return this.value;
    }

    public abstract int bytes();

    public abstract void writeTo(@Nonnull ByteBuffer var1);

    public abstract void readFrom(@Nonnull ByteBuffer var1);

    public static int requiredBytes(@Nonnull Feature[] x) {
        int ret = 0;
        for (Feature f : x) {
            assert (f != null);
            ret += f.bytes();
        }
        return ret;
    }

    @Nullable
    public static Feature[] parseFeatures(@Nonnull Object arg, @Nonnull ListObjectInspector listOI, @Nullable Feature[] probes, boolean asIntFeature) throws HiveException {
        if (arg == null) {
            return null;
        }
        int length = listOI.getListLength(arg);
        Feature[] ary = probes != null && probes.length == length ? probes : new Feature[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(arg, i);
            if (o == null) continue;
            String s = o.toString();
            Feature f = ary[j];
            if (f == null) {
                f = Feature.parseFeature(s, asIntFeature);
            } else {
                Feature.parseFeature(s, f, asIntFeature);
            }
            ary[j] = f;
            ++j;
        }
        if (j == length) {
            return ary;
        }
        Feature[] dst = new Feature[j];
        System.arraycopy(ary, 0, dst, 0, j);
        return dst;
    }

    public static Feature[] parseFFMFeatures(@Nonnull Object arg, @Nonnull ListObjectInspector listOI, @Nullable Feature[] probes, int numFeatures, int numFields) throws HiveException {
        if (arg == null) {
            return null;
        }
        int length = listOI.getListLength(arg);
        Feature[] ary = probes != null && probes.length == length ? probes : new Feature[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Object o = listOI.getListElement(arg, i);
            if (o == null) continue;
            String s = o.toString();
            Feature f = ary[j];
            if (f == null) {
                f = Feature.parseFFMFeature(s, numFeatures, numFields);
            } else {
                Feature.parseFFMFeature(s, f, numFeatures, numFields);
            }
            ary[j] = f;
            ++j;
        }
        if (j == length) {
            return ary;
        }
        Feature[] dst = new Feature[j];
        System.arraycopy(ary, 0, dst, 0, j);
        return dst;
    }

    @Nonnull
    static Feature parseFeature(@Nonnull String fv, boolean asIntFeature) throws HiveException {
        int pos1 = fv.indexOf(58);
        if (pos1 == -1) {
            if (asIntFeature) {
                int index = Feature.parseFeatureIndex(fv);
                return new IntFeature(index, 1.0);
            }
            return new StringFeature(fv, 1.0);
        }
        String indexStr = fv.substring(0, pos1);
        String valueStr = fv.substring(pos1 + 1);
        if (asIntFeature) {
            int index = Feature.parseFeatureIndex(indexStr);
            double value = Feature.parseFeatureValue(valueStr);
            return new IntFeature(index, value);
        }
        double value = Feature.parseFeatureValue(valueStr);
        return new StringFeature(indexStr, value);
    }

    @Nonnull
    static IntFeature parseFFMFeature(@Nonnull String fv) throws HiveException {
        return Feature.parseFFMFeature(fv, 0x200000, 1024);
    }

    @Nonnull
    static IntFeature parseFFMFeature(@Nonnull String fv, int numFeatures, int numFields) throws HiveException {
        short field;
        int index;
        int pos1 = fv.indexOf(58);
        if (pos1 == -1) {
            throw new HiveException("Invalid FFM feature format: " + fv);
        }
        String lead = fv.substring(0, pos1);
        String rest = fv.substring(pos1 + 1);
        int pos2 = rest.indexOf(58);
        if (pos2 == -1) {
            int index2;
            if (NumberUtils.isDigits(lead)) {
                index2 = Feature.parseFeatureIndex(lead);
                if (index2 < 0 || index2 >= numFields) {
                    throw new HiveException("Invalid index value '" + index2 + "' for a quantative features: " + fv + ", expecting index less than " + numFields);
                }
            } else {
                index2 = MurmurHash3.murmurhash3(lead, numFields);
            }
            short field2 = (short)index2;
            double value = Feature.parseFeatureValue(rest);
            return new IntFeature(index2, field2, value);
        }
        String indexStr = rest.substring(0, pos2);
        if (NumberUtils.isDigits(indexStr) && NumberUtils.isDigits(lead)) {
            index = Feature.parseFeatureIndex(indexStr);
            if (index >= numFeatures + numFields) {
                throw new HiveException("Feature index MUST be less than " + (numFeatures + numFields) + " but was " + index);
            }
            field = Feature.parseField(lead, numFields);
        } else {
            index = MurmurHash3.murmurhash3(indexStr, numFeatures) + numFields;
            field = (short)MurmurHash3.murmurhash3(lead, numFields);
        }
        String valueStr = rest.substring(pos2 + 1);
        double value = Feature.parseFeatureValue(valueStr);
        return new IntFeature(index, field, value);
    }

    static void parseFeature(@Nonnull String fv, @Nonnull Feature probe, boolean asIntFeature) throws HiveException {
        int pos1 = fv.indexOf(":");
        if (pos1 == -1) {
            if (asIntFeature) {
                int index = Feature.parseFeatureIndex(fv);
                probe.setFeatureIndex(index);
            } else {
                probe.setFeature(fv);
            }
            probe.value = 1.0;
        } else {
            String indexStr = fv.substring(0, pos1);
            String valueStr = fv.substring(pos1 + 1);
            if (asIntFeature) {
                int index = Feature.parseFeatureIndex(indexStr);
                probe.setFeatureIndex(index);
                probe.value = Feature.parseFeatureValue(valueStr);
            } else {
                probe.setFeature(indexStr);
                probe.value = Feature.parseFeatureValue(valueStr);
            }
        }
    }

    static void parseFFMFeature(@Nonnull String fv, @Nonnull Feature probe) throws HiveException {
        Feature.parseFFMFeature(fv, probe, 0x200000, 1024);
    }

    static void parseFFMFeature(@Nonnull String fv, @Nonnull Feature probe, int numFeatures, int numFields) throws HiveException {
        short field;
        int index;
        int pos1 = fv.indexOf(":");
        if (pos1 == -1) {
            throw new HiveException("Invalid FFM feature format: " + fv);
        }
        String lead = fv.substring(0, pos1);
        String rest = fv.substring(pos1 + 1);
        int pos2 = rest.indexOf(58);
        if (pos2 == -1) {
            int index2;
            if (NumberUtils.isDigits(lead)) {
                index2 = Feature.parseFeatureIndex(lead);
                if (index2 < 0 || index2 >= numFields) {
                    throw new HiveException("Invalid index value '" + index2 + "' for a quantative features: " + fv + ", expecting index less than " + numFields);
                }
            } else {
                index2 = MurmurHash3.murmurhash3(lead, numFields);
            }
            short field2 = (short)index2;
            probe.setField(field2);
            probe.setFeatureIndex(index2);
            probe.value = Feature.parseFeatureValue(rest);
            return;
        }
        String indexStr = rest.substring(0, pos2);
        if (NumberUtils.isDigits(indexStr) && NumberUtils.isDigits(lead)) {
            index = Feature.parseFeatureIndex(indexStr);
            if (index >= numFeatures + numFields) {
                throw new HiveException("Feature index MUST be less than " + (numFeatures + numFields) + " but was " + index);
            }
            field = Feature.parseField(lead, numFields);
        } else {
            index = MurmurHash3.murmurhash3(indexStr, numFeatures) + numFields;
            field = (short)MurmurHash3.murmurhash3(lead, numFields);
        }
        probe.setField(field);
        probe.setFeatureIndex(index);
        String valueStr = rest.substring(pos2 + 1);
        probe.value = Feature.parseFeatureValue(valueStr);
    }

    private static int parseFeatureIndex(@Nonnull String indexStr) throws HiveException {
        int index;
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new HiveException("Invalid index value: " + indexStr, (Throwable)e);
        }
        if (index < 0) {
            throw new HiveException("Feature index MUST be greater than 0: " + indexStr);
        }
        return index;
    }

    private static double parseFeatureValue(@Nonnull String value) throws HiveException {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new HiveException("Invalid feature value: " + value, (Throwable)e);
        }
    }

    private static short parseField(@Nonnull String fieldStr, int numFields) throws HiveException {
        short field;
        try {
            field = Short.parseShort(fieldStr);
        }
        catch (NumberFormatException e) {
            throw new HiveException("Invalid field value: " + fieldStr, (Throwable)e);
        }
        if (field < 0 || field >= numFields) {
            throw new HiveException("Invalid field value: " + fieldStr);
        }
        return field;
    }

    public static int toIntFeature(@Nonnull Feature x, int yField, int numFields) {
        int index = x.getFeatureIndex();
        return index * numFields + yField;
    }
}

