/*
 * Decompiled with CFR 0.152.
 */
package hivemall.fm;

import hivemall.fm.FMHyperParameters;
import hivemall.fm.FactorizationMachineModel;
import hivemall.fm.Feature;
import hivemall.utils.collections.IMapIterator;
import hivemall.utils.collections.OpenHashTable;
import javax.annotation.Nonnull;

public final class FMStringFeatureMapModel
extends FactorizationMachineModel {
    private static final int DEFAULT_MAPSIZE = 4096;
    private float _w0 = 0.0f;
    private final OpenHashTable<String, Entry> _map = new OpenHashTable(4096);

    public FMStringFeatureMapModel(@Nonnull FMHyperParameters params) {
        super(params);
    }

    @Override
    public int getSize() {
        return this._map.size();
    }

    IMapIterator<String, Entry> entries() {
        return this._map.entries();
    }

    @Override
    public float getW0() {
        return this._w0;
    }

    @Override
    protected void setW0(float nextW0) {
        this._w0 = nextW0;
    }

    @Override
    public float getW(@Nonnull Feature x) {
        String j = x.getFeature();
        assert (j != null);
        Entry entry = this._map.get(j);
        if (entry == null) {
            return 0.0f;
        }
        return entry.W;
    }

    @Override
    protected void setW(@Nonnull Feature x, float nextWi) {
        String j = x.getFeature();
        assert (j != null);
        Entry entry = this._map.get(j);
        if (entry == null) {
            float[] Vf = this.initV();
            entry = new Entry(nextWi, Vf);
            this._map.put(j, entry);
        } else {
            entry.W = nextWi;
        }
    }

    @Override
    public float getV(@Nonnull Feature x, int f) {
        float[] V;
        String j = x.getFeature();
        assert (j != null);
        Entry entry = this._map.get(j);
        if (entry == null) {
            V = this.initV();
            entry = new Entry(0.0f, V);
            this._map.put(j, entry);
        } else {
            V = entry.Vf;
            assert (V != null);
        }
        return V[f];
    }

    @Override
    protected void setV(@Nonnull Feature x, int f, float nextVif) {
        float[] V;
        String j = x.getFeature();
        assert (j != null);
        Entry entry = this._map.get(j);
        if (entry == null) {
            V = this.initV();
            entry = new Entry(0.0f, V);
            this._map.put(j, entry);
        } else {
            V = entry.Vf;
            assert (V != null);
        }
        V[f] = nextVif;
    }

    static final class Entry {
        float W;
        @Nonnull
        final float[] Vf;

        Entry(float W, @Nonnull float[] Vf) {
            this.W = W;
            this.Vf = Vf;
        }
    }
}

